% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqnClass.R
\name{subset.eqnlist}
\alias{subset.eqnlist}
\title{subset of an equation list}
\usage{
\method{subset}{eqnlist}(x, ...)
}
\arguments{
\item{x}{the equation list}

\item{...}{logical expression for subsetting}
}
\value{
An object of class \link{eqnlist}
}
\description{
subset of an equation list
}
\details{
The argument \code{...} can contain "Educt", "Product", "Rate" and "Description".
The "%in%" operator is modified to allow searches in Educt and Product (see examples).
}
\examples{
reactions <- data.frame(Description = c("Activation", "Deactivation"), 
                        Rate = c("act*A", "deact*pA"), A=c(-1,1), pA=c(1, -1) )
f <- as.eqnlist(reactions)
subset(f, "A" \%in\% Educt)
subset(f, "pA" \%in\% Product)
subset(f, grepl("act", Rate))
}
