% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/man-lemna.R
\name{Lemna-models}
\alias{Lemna-models}
\alias{Lemna-class}
\title{Lemna models}
\description{
Overview of supported \emph{Lemna} models
}
\details{
\itemize{
\item \code{\link[=Lemna_Schmitt]{Lemna_Schmitt()}} by Schmitt \emph{et al.} (2013)
\item \code{\link[=Lemna_SETAC]{Lemna_SETAC()}} by Klein \emph{et al.} (2021)
}
}
\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. Lemna effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

Any transfer time point must also be an output time point. If a transfer
occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that in order to use transfers at regular
intervals, the simulation must start at time point zero.
}

\seealso{
\link{Macrophyte-models}

Other Lemna models: 
\code{\link{Lemna_SETAC}()},
\code{\link{Lemna_Schmitt}()}

Other models: 
\code{\link{Algae-models}},
\code{\link{DEB-models}},
\code{\link{GUTS-RED-models}},
\code{\link{Macrophyte-models}},
\code{\link{Myriophyllum-models}}
}
\concept{Lemna models}
\concept{models}
