% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv-mixed-models.R
\name{cvMixed}
\alias{cvMixed}
\alias{cv.merMod}
\alias{cv.lme}
\alias{cv.glmmTMB}
\title{Cross-Validate Mixed-Effects Model}
\usage{
cvMixed(
  model,
  data = insight::get_data(model),
  criterion = mse,
  k,
  reps = 1,
  seed,
  ncores = 1,
  clusterVariables,
  predict.clusters.args = list(object = model, newdata = data),
  predict.cases.args = list(object = model, newdata = data),
  ...
)

\method{cv}{merMod}(
  model,
  data = insight::get_data(model),
  criterion = mse,
  k,
  reps = 1,
  seed,
  ncores = 1,
  clusterVariables,
  ...
)

\method{cv}{lme}(
  model,
  data = insight::get_data(model),
  criterion = mse,
  k,
  reps = 1,
  seed,
  ncores = 1,
  clusterVariables,
  ...
)

\method{cv}{glmmTMB}(
  model,
  data = insight::get_data(model),
  criterion = mse,
  k,
  reps = 1,
  seed,
  ncores = 1,
  clusterVariables,
  ...
)
}
\arguments{
\item{model}{a regression model object of class \code{"merMod"}.}

\item{data}{data frame to which the model was fit (not usually necessary)}

\item{criterion}{cross-validation criterion function of form \code{f(y, yhat)}
where \code{y} is the observed values of the response and
\code{yhat} the predicted values; the default is \code{\link{mse}}
(the mean-squared error)}

\item{k}{perform k-fold cross-validation; \code{k}
may be a number or \code{"loo"} or \code{"n"} for n-fold (leave-one-out)
cross-validation; the default is \code{10} if cross-validating individual
cases and \code{"loo"} if cross-validating clusters.}

\item{reps}{number of times to replicate k-fold CV (default is \code{1})}

\item{seed}{for R's random number generator; optional, if not
supplied a random seed will be selected and saved; not needed
for n-fold cross-validation}

\item{ncores}{number of cores to use for parallel computations
(default is \code{1}, i.e., computations aren't done in parallel)}

\item{clusterVariables}{a character vector of names of the variables
defining clusters for a mixed model with nested random effects;
if missing, cross-validation is performed for individual cases rather than
for clusters}

\item{predict.clusters.args}{a list of arguments to be used to predict
the whole data set from a mixed model when performing CV on clusters;
the first two elements should be
\code{model} and \code{newdata}; see the "Extending the cv package" vignette
(\code{vignette("cv-extend", package="cv")}).}

\item{predict.cases.args}{a list of arguments to be used to predict
the whole data set from a mixed model when performing CV on cases;
the first two elements should be
\code{model} and \code{newdata}; see the "Extending the cv package" vignette
(\code{vignette("cv-extend", package="cv")}).}

\item{...}{for \code{cv()} methods, to match generic,
and for \code{cvMixed()}, arguments to be passed to \code{update()}.}
}
\value{
\code{cvMixed()}, and functions based on it, such as the methods
\code{cv.merMod()}, \code{cv.lme()}, \code{cv.glmmTMB()}, return objects of class \code{"cv"}, or,
if \code{reps > 1}, of class \code{"cvList"} (see \code{\link{cv}()}).
}
\description{
\code{\link{cv}()} methods for models of class \code{"merMod"}, fit
by the \code{\link[lme4]{lmer}()} and \code{\link[lme4]{glmer}()} functions
in the \pkg{lme4} package; for models of class \code{"lme"}
fit by the \code{\link[nlme]{lme}()} function in the \pkg{nlme}
package; and for models of class \code{"glmmTMB"} fit by the
\code{\link[glmmTMB]{glmmTMB}()} function in the \pkg{glmmTMB} package.
The implementations here should be regarded
as experimental. The \code{cvMixed()} function is meant to be called by
\code{cv()} methods for mixed-effect models and not directly by the user.
}
\details{
For mixed-effects models, cross-validation can be done by "clusters" or by
individual observations. If the former, predictions are based only on fixed
effects; if the latter, predictions include the random effects. Only mixed
models with fully nested random effects are supported.
}
\section{Functions}{
\itemize{
\item \code{cvMixed()}: not to be called directly

\item \code{cv(merMod)}: \code{cv()} method

\item \code{cv(lme)}: \code{cv()} method

\item \code{cv(glmmTMB)}: \code{cv()} method

}}
\examples{
library("lme4")
# from ?lmer:
(fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy))
cv(fm1, clusterVariables="Subject") # LOO CV of clusters
cv(fm1, seed=447) # 10-fold CV of cases
cv(fm1, clusterVariables="Subject", k=5,
   seed=834, reps=3) # 5-fold CV of clusters, repeated 3 times

library(nlme)
# from ?lme
(fm2 <- lme(distance ~ age + Sex, data = Orthodont,
            random = ~ 1))
cv(fm2) # LOO CV of cases
cv(fm2, clusterVariables="Subject", k=5, seed=321) # 5-fold CV of clusters

}
\seealso{
\code{\link{cv}}, \code{\link[lme4]{lmer}}, \code{\link[lme4]{glmer}},
\code{\link[nlme]{lme}}, \code{\link[glmmTMB]{glmmTMB}}
}
