% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrdata-trial-concepts.R
\docType{data}
\name{ctrdata-trial-concepts}
\alias{ctrdata-trial-concepts}
\title{Trial concepts implemented across registers}
\description{
\code{ctrdata} includes (since version 1.21.0) functions that implement selected
trial concepts. Concepts of clinical trials, such as their start or status of
recruitment, require to analyse several fields against various
pre-defined values. The structure and value sets of fields differ between
all \link{ctrdata-registers}. In this situation, the implemented trial
concepts simplify and accelerate a user's analysis workflow and also increase
analysis consistency.
}
\details{
The implementation of trial concepts in \code{ctrdata} has not been validated
with any formal approach, but has been checked for plausibility and
against expectations. The implementation is based on current
understanding, on public data models and on scientific papers, as relevant.
As with other \code{R} functions, call \code{help("f.startDate")} or print its
implementation code by entering the name of the function as command,
e.g. \code{f.startDate}.
Please raise an issue \href{https://github.com/rfhb/ctrdata/issues}{here}
to ask about or improve a trial concept.

The following trial concepts can be used by referencing their name when
calling \link{dbGetFieldsIntoDf} (parameter \code{calculate}).
Concepts will continue to be refined and added;
last updated 2025-03-09.
\itemize{
\item \link{f.controlType} (factor) which type of internal or concurrent control is
used in the trial? ("none", "no-treatment", "placebo", "active",
"placebo+active" or "other")
\item \link{f.isMedIntervTrial} (logical) is the trial interventional and does
it have one or more medicines (drugs or biological) as investigational
(experimental) intervention? (irrespective of status of authorisation and
of study design)
\item \link{f.isUniqueTrial} (logical) is the trial record unique in the data frame
of trial, based on the default parameters of \link{dbFindIdsUniqueTrials}?
\item \link{f.likelyPlatformTrial} (logical) is the trial possibly a (research)
platform trial, and what are related trials? (based on trial title,
f.numTestArmsSubstances, number of periods)
\item \link{f.numSites} (integer) how many sites does the trial have?
\item \link{f.numTestArmsSubstances} (integer) how many arms or groups have
medicines that are investigational? (cannot be calculated for ISRCTN or
for phase 1 trials)
\item \link{f.primaryEndpointDescription} (list of character) string containing
protocol definition, details and time frames, concatenated with " == "
\item \link{f.primaryEndpointResults} (columns of number, character, integer)
returning the statistical testing p value and method as well as the number
of subjects included in the test, each in one new column, for the first
primary endpoint only
\item \link{f.resultsDate} (date) the planned or achieved date of results availability
\item \link{f.startDate} (date) the planned, authorised or documented date
of start of recruitment
\item \link{f.sampleSize} (integer) the achieved (or planned) number of subjects or
participants recruited
\item \link{f.sponsorType} (factor) a type or class of main or lead sponsor that is
simplified to "not for profit", "for profit" or "other"
\item \link{f.statusRecruitment} (factor) a status that is simplified to
"ongoing" (includes temporarily halted), "completed", "ended early" (includes
terminated or ended prematurely) and "other" (includes planned, stopped,
withdrawn)
\item \link{f.trialObjectives} (string) identifies with letters those objectives
that could be identified by text fragments, e.g. "E S PD D", with "E"
(efficacy), "S" (safety), "D" (dose-finding)
\item \link{f.trialPhase} (ordered factor) the phase(s) of medicine development
with which a trial is associated
\item \link{f.trialPopulation} (columns of factor, string and string) age groups
(e.g., "P" for paediatric participants, "A" for adults, "E" for older than
65 years, or "P+A"), inclusion and exclusion criteria texts
}
}
\author{
Ralf Herold \email{ralf.herold@mailbox.org}
}
\keyword{data}
