% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attcpo.R
\name{attcpo}
\alias{attcpo}
\title{attcpo}
\usage{
attcpo(formla, t, tmin1, tmin2, tname, data, idname, Y0tqteobj, h = NULL,
  yseq = NULL, yseqlen = 100, se = TRUE, iters = 100,
  method = "level")
}
\arguments{
\item{formla}{e.g. y ~ treat}

\item{t}{the last time period}

\item{tmin1}{the middle time period}

\item{tmin2}{the first time period}

\item{tname}{the name of the column containing time periods in the data}

\item{data}{a data.frame}

\item{idname}{the name of the column containing an individual identifier over time}

\item{Y0tqteobj}{a qte object (from the qte package) containing the
the counterfactual distribution of untreated potential outcomes for the
treated group}

\item{h}{optional bandwidth}

\item{yseq}{optional sequence of y values, default is to use all unique
yvalues in the data, though this can increase computation time}

\item{yseqlen}{optional length of y values to use, aids in automatically
generating yseq if desired}

\item{se}{whether or not to compute standard errors}

\item{iters}{how many bootstrap iterations to use if computing standard errors; default is 100.}

\item{method}{should be either "levels" or "rank"; whether to compute the
ATT-CPO using based on the levels of Y0tmin1 or the ranks of Y0tmin1;
"levels" is the default.}
}
\value{
att-cpo
}
\description{
compute the Average Treatment Effect on the Treated
 Conditional on the previous outcome (ATT-CPO)
}
\examples{
data(displacements)
cc <- qte::CiC(learn ~ treat,
               t=2011, tmin1=2007, tname="year",
               idname="id", panel=TRUE, data=displacements,
               probs=seq(.05,.95,.01),se=FALSE)
cc$F.treated.tmin1 <- ecdf(subset(displacements, year==2007 & treat==1)$learn)
cc$F.treated.tmin2 <- ecdf(subset(displacements, year==2003 & treat==1)$learn)
ac <- attcpo(learn ~ treat, 2011, 2007, 2003, "year", displacements,
        "id", cc, method="rank", yseqlen=10)
ac
ggattcpo(ac)

}
