% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attcpo.R
\name{E.Y0}
\alias{E.Y0}
\title{E.Y0}
\usage{
E.Y0(ytmin1val, Y0tmin1, Y0tmin2, Y0tqteobj, h = NULL, method = "level")
}
\arguments{
\item{ytmin1val}{the value to compute the conditional expectation for}

\item{Y0tmin1}{a vector of untreated potential outcomes for the treated
group in period t-1}

\item{Y0tmin2}{a vector of untreated potential outcomes for the treated
group in period t-2}

\item{Y0tqteobj}{a qte object which should have set F.treated.t.cf
which is the counterfactual distribution of untreated potential outcomes
for the treated group in period t}

\item{h}{optional bandwidth paramater}

\item{method}{can be "level" or "rank", whether the conditional expectation
is based on the level of Y0tmin1 or its rank}
}
\description{
a function for computing the conditional expectation of
  Y_0t given particular value of y_tmin1 under the Copula Stability
  Assumption
}
\examples{
data(displacements)
ytmin1 <- 10
Y0tmin1 <- subset(displacements, year==2007 & treat==1)$learn
Y0tmin2 <- subset(displacements, year==2003 & treat==1)$learn
cc <- qte::CiC(learn ~ treat,
               t=2011, tmin1=2007, tname="year",
               idname="id", panel=TRUE, data=displacements,
               probs=seq(.05,.95,.01),se=FALSE)
cc$F.treated.tmin2 <- ecdf(subset(displacements, year==2003 & treat==1)$learn)
cc$F.treated.tmin1 <- ecdf(subset(displacements, year==2007 & treat==1)$learn)
E.Y0(ytmin1, Y0tmin1, Y0tmin2, cc)

}
