#' Satellite data (GPM-IMERG)
#'
#' GPM IMERG Final Precipitation L3 1 day 0.1 degree x 0.1 degree for Holland
#' at daily time step for period 2014-03-12 to 2018-05-15.
#' Spatial averaged over: latitude: 50.75, 53.55, longitude: 3.45, 7.15
#'
#' @docType data
#'
#' @usage data(gpm_nl)
#'
#' @keywords datasets
#'
#' @source \href{https://climexp.knmi.nl/select.cgi?id=312456c83e660703df1bfea9ba4fba50&field=imerg_daily}{KNMI explorer}
#'
#' @examples
#' str(gpm_nl)

"gpm_nl"

#' GPM-IMERG precipitation events over 10 mm/day
#'
#' GPM IMERG Final Precipitation L3 1 day 0.1 degree x 0.1 degree for Holland
#' at daily time step for period 2014-03-12 to 2018-05-15.
#' Spatial averaged over: latitude: 50.75, 53.55, longitude: 3.45, 7.15
#'
#' @docType data
#'
#' @usage data(gpm_events)
#'
#' @keywords datasets
#'
#' @source \href{https://climexp.knmi.nl/select.cgi?id=312456c83e660703df1bfea9ba4fba50&field=imerg_daily}{KNMI explorer}
#'
#' @examples
#' str(gpm_events)

"gpm_events"

#' Simulation data (CNRM)
#'
#' Model cnrm-cm3; scenario 20c3m; variable  pr.
#' 24 h 2.8 degree x 2.8 degree for Holland
#' at daily time step for period 1961-01-01 to 2000-12-31.
#' Spatial Region: 1 grid cell at latitude: 51.625, longitude: 5.625
#'
#' @docType data
#'
#' @usage data(cnrm_nl)
#'
#' @keywords datasets
#'
#' @source \href{https://climexp.knmi.nl/select.cgi?id=312456c83e660703df1bfea9ba4fba50&field=pr_A2_cnrm_cm3_20c3m}{KNMI explorer}
#'
#' @examples
#' str(cnrm_nl)

"cnrm_nl"

#' Station data (KNMI)
#'
#' 240 homogenized stations 1951-now.
#' 24 h point data for Holland
#' at daily time step for period 1950-12-31 to 2018-04-29.
#' Spatial Region: latitude: 50.78, 53.48, longitude: 3.4, 7.11
#'
#' @docType data
#'
#' @usage data(knmi_nl)
#'
#' @keywords datasets
#'
#' @source \href{https://climexp.knmi.nl/PhomNL.cgi?id=312456c83e660703df1bfea9ba4fba50}{KNMI explorer}
#'
#' @examples
#' str(knmi_nl)

"knmi_nl"

#' Reanalysis data (NCEP/NCAR)
#'
#' NMC reanalysis 24 h 2.5 degree x 2.5 degree for Holland
#' at daily time step for period 1948-01-01 to 2018-06-05.
#' Spatial Region: 1 grid cell at latitude: 52.38, longitude: 5.625
#'
#' @docType data
#'
#' @usage data(ncep_nl)
#'
#' @keywords datasets
#'
#' @source \href{https://climexp.knmi.nl/select.cgi?id=312456c83e660703df1bfea9ba4fba50&field=nprate_daily}{KNMI explorer}
#'
#' @examples
#' str(ncep_nl)

"ncep_nl"

#' Radar data (KNMI)
#'
#' RAD_NL25_RAC_MFBS_24H_NC
#' 24 h 1 km x 1 km for Holland
#' at daily time step for period 2014-03-11 to 2018-03-30.
#' Spatial Region: latitude: 50.76, 53.56, longitude: 3.37, 7.22
#'
#' @docType data
#'
#' @usage data(rdr_nl)
#'
#' @keywords datasets
#'
#' @source \href{https://climexp.knmi.nl/select.cgi?id=312456c83e660703df1bfea9ba4fba50&field=knmi_radar_daily}{KNMI explorer}
#'
#' @examples
#' str(rdr_nl)

"rdr_nl"
