% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_indicators.R
\name{addRSI}
\alias{addRSI}
\title{Add RSI indicators to your
chart}
\usage{
addRSI(chart, ...)
}
\arguments{
\item{chart}{a \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} chart}

\item{...}{See \code{\link[TTR:RSI]{TTR::RSI()}}}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The RSI can be customized with different look-back periods to suit various trading strategies and timeframes.
It is a valuable tool for assessing the momentum and relative strength of an asset, helping traders make more informed decisions in financial markets.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

# library
library(cryptoQuotes)

# charting klines
# with various indicators
chart(
  chart = kline(
    ATOMUSDT
  ) \%>\% addVolume() \%>\% addMA(
    FUN = TTR::SMA,
    n = 7
  ) \%>\% addMA(
    FUN = TTR::SMA,
    n = 14
  ) \%>\%
    addBBands() \%>\%
    addMACD() \%>\%
    addRSI()

)


# script end;
}
\seealso{
Other chart indicators: 
\code{\link{addBBands}()},
\code{\link{addEvents}()},
\code{\link{addFGIndex}()},
\code{\link{addLSRatio}()},
\code{\link{addMACD}()},
\code{\link{addMA}()},
\code{\link{addVolume}()},
\code{\link{chart}()}
}
\concept{chart indicators}
