% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflections.R
\name{generate_miller}
\alias{generate_miller}
\title{Generate Miller indices}
\usage{
generate_miller(uc, SG, reso)
}
\arguments{
\item{uc}{An object of class "unit_cell".}

\item{SG}{A character string or a number indicating the
extended Hermann-Mauguin symbol for the space group.}

\item{reso}{A real number. The highest data resolution, in
angstroms.}
}
\value{
hkl A data frame with columns H, K, L corresponding
            to the three Miller indices, and a columns S
            corresponding to their inverse resolutions (in
            angstroms).
}
\description{
Function to create a data frame with complete set of Miller
indices, up to a given resolution (in angstroms).
}
\details{
Miller indices are named H, K, L in the data frame. Only
values of (H,K,L) corresponding to a resolution d(h,k,l) >=
reso (in angstroms), are included. The full list does not
include systematic absences corresponding to the specific
symmetry of the crystal.
}
\examples{
# C 2 monoclinic space group
SG <- "C 1 2 1"

# Create an arbitrary cell compatible with C 2
uc <- unit_cell(10,15,10,90,110,90)

# Generate Miller indices to 5 angstroms resolution
reso <- 5
hkl <- generate_miller(uc,SG,reso)

# Display first 10 indices
hkl[1:10,]

}
