% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{findHM}
\alias{findHM}
\title{Correct spelling for Herman-Mauguin space groups symbols}
\usage{
findHM(sym_xHM)
}
\arguments{
\item{sym_xHM}{A character string. The space group symbol in its commonly-used spelling.}
}
\value{
SG A character string. The extended Hermann-Mauguin symbol (e.g. 'P 1 1 21').
}
\description{
The commonly-used spelling of a crystallographic space group does not match the correct definition
given by the Herman-Mauguin symbols which define all space groups in a unique and precise way. This
function attempt to translate a tentative string into a possible Herman-Mauguin symbol, if it finds
one. If the input string is already in the extended Herman-Mauguin form, the same string is returned
as output.
}
\examples{
# P21
print(find("P 21"))

# P -1
print(find("P-1"))

}
