% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdrtv.R
\name{readpd_rtv}
\alias{readpd_rtv}
\title{Reads and output an CIF file}
\usage{
readpd_rtv(filename, messages = FALSE)
}
\arguments{
\item{filename}{A character string. The path to a valid CIF file.}

\item{messages}{A logical variable. If TRUE (default) the function prints
a message highlighting what is included in the cif file.}
}
\value{
A named list. Each name correspond to a valid field in the powder
   diffraction Rietveld processed CIF.
}
\description{
Reads and output an CIF file
}
\examples{
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"e-65-00i60-Isup2.rtv")
lCIF <- readpd_rtv(filename)
print(names(lCIF))
print(lCIF$INTRO$CELL)
print(lCIF$INTRO$HALL)
print(lCIF$INTRO$HM)
print(lCIF$REFL)

}
