% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_S3.R
\name{create_unit_cell.cryst_symm}
\alias{create_unit_cell.cryst_symm}
\title{Unit cell from a 'cryst_symm' object}
\usage{
\method{create_unit_cell}{cryst_symm}(a, ...)
}
\arguments{
\item{a}{An object of class 'cryst_symm'.}

\item{...}{Additional arguments passed to the create_unit_cell.}
}
\value{
An object of class "unit_cell". It is a named list
        of length 6 whose last three slots are of class
        'angle'. Default cell parameters are a=10, b=20, c=15,
        alpha=70, beta=80, gamma=100. When constrains due to
        symmetry are required, b and c might be equaled to a,
        alpha, beta and gamma might be set to 90, gamma might
        be set to 120 and the three angles might be set
        equal to each other.
}
\description{
Method to create an object of class "unit_cell" starting
from an object of class 'cryst_symm'.
}
\details{
The symmetry of a space group imposes constrains on the
parameters of unit cells. For example, the cubic group P 2 3
means that all cell sides have to be equal and all angles
have to be equal to 90 degrees. This function suggests the
appropriate unit cell compatible with the given space group.
}
\examples{
# Symmetry "C 1 2/c 1"
csym <- cryst_symm("C 1 2/c 1")

# Unit_cell
uc <- create_unit_cell(csym)
print(uc)

}
