% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-data-frame.R
\name{catalog-dataframes}
\alias{catalog-dataframes}
\alias{as.data.frame.VariableCatalog}
\alias{as.data.frame.ShojiCatalog}
\alias{as.data.frame.BatchCatalog}
\alias{as.data.frame.FilterCatalog}
\alias{as.data.frame.UserCatalog}
\title{as.data.frame method for catalog objects}
\usage{
\method{as.data.frame}{VariableCatalog}(
  x,
  row.names = NULL,
  optional = FALSE,
  keys = c("alias", "name", "type"),
  ...
)

\method{as.data.frame}{ShojiCatalog}(x, row.names = NULL, optional = FALSE, ...)

\method{as.data.frame}{BatchCatalog}(
  x,
  row.names = NULL,
  optional = FALSE,
  keys = c("id", "status"),
  ...
)

\method{as.data.frame}{FilterCatalog}(
  x,
  row.names = NULL,
  optional = FALSE,
  keys = c("name", "id", "is_public"),
  ...
)

\method{as.data.frame}{UserCatalog}(
  x,
  row.names = NULL,
  optional = FALSE,
  keys = c("name", "email", "teams", "collaborator"),
  ...
)
}
\arguments{
\item{x}{A catalog object}

\item{row.names}{A character vector of elements to use as row labels for the
resulting data.frame, or \code{NULL}, the default, adds no row labels.}

\item{optional}{part of \code{as.data.frame} signature. Ignored.}

\item{keys}{A character vector of the catalog attributes that you
would like included in the data.frame. To include all attributes, set keys to
\code{TRUE}, which is the default for some catalogs. Other catalog classes specify
a narrower default:
\itemize{
\item VariableCatalog: \code{c("alias", "name", "type")}
\item BatchCatalog: \code{c("id", "status")}
\item FilterCatalog: \code{c("name", "id", "is_public")}
}}

\item{...}{Additional arguments passed to \code{data.frame}}
}
\value{
A \code{data.frame} including metadata about each entity contained in the
catalog. The fields in the data.frame match the \code{keys} argument
provided to the function, and each row represents a entity.
}
\description{
This method gives you a view of a catalog, such as a \code{VariableCatalog}, as a
\code{data.frame} in order to facilitate further exploration.
}
\details{
Modifying the \code{data.frame} produced by this function will not update the
objects on the Crunch server. Other methods exist for updating the metadata
in the variable catalog, for example. See \code{vingette("variables", package = "crunch")}.
}
\examples{
\dontrun{
ds <- loadDataset("iris")
vars <- variables(ds)
var_df <- as.data.frame(vars, keys = TRUE)
# With row names
as.data.frame(vars, row.names = urls(vars))
}

}
