% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-residuals.R
\name{dimension-comparison-pairwise}
\alias{dimension-comparison-pairwise}
\alias{compareColsPairwise}
\alias{compareRowsPairwise}
\alias{compareDimsPairwise}
\title{Pairwise column and row comparison}
\usage{
compareColsPairwise(cube, ...)

compareRowsPairwise(cube, ...)

compareDimsPairwise(cube, dim = c("cols", "rows"), baseline)
}
\arguments{
\item{cube}{a cube to calculate the comparison on}

\item{...}{arguments passed from \code{compareRowsPairwise()} or
\code{compareColsPairwise()} to \code{compareDimsPairwise()} (i.e. \code{baseline})}

\item{dim}{which dimension is being compared (\code{rows} or \code{cols}, only valid
for \code{compareDims()})}

\item{baseline}{a character, the column to use as a baseline to compare
against all other columns}
}
\value{
an array of z-score for the all the columns or rows compared to
\code{baseline}. The \code{baseline} column is all 0s
}
\description{
Given a single baseline column compare each other row or column against this
baseline. Internally this function uses \code{compareDims()} iteratively.
}
\details{
\emph{Warning} since there is more than one comparison being made against each
baseline the z-scores, and especially the p-values derived from these
z-scores should be interpreted with caution. Using standard p-value cutoffs
will result in anti-conservative interpretations because of the \href{https://en.wikipedia.org/wiki/Multiple_comparisons_problem}{multiple
comparisons problem}.
Adjustments to p-value cut offs (e.g. \href{https://en.wikipedia.org/wiki/Bonferroni_correction}{Bonferonni correction}) should be used when interpreting z-scores from the
\code{compare[Rows|Cols|Dims]Pairwise()} family of functions.
}
