% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\docType{data}
\name{HttpClient}
\alias{HttpClient}
\title{HTTP client}
\arguments{
\item{url}{(character) A url. One of \code{url} or \code{handle} required.}

\item{opts}{(list) curl options}

\item{handle}{A handle}
}
\description{
HTTP client
}
\details{
\strong{Methods}
  \describe{
    \item{\code{get(path, query, ...)}}{
      Make a GET request
    }
    \item{\code{post(path, query, body, ...)}}{
      Make a POST request
    }
    \item{\code{put(path, query, body, ...)}}{
      Make a PUT request
    }
    \item{\code{patch(path, query, body, ...)}}{
      Make a PATCH request
    }
    \item{\code{delete(path, query, body, ...)}}{
      Make a DELETE request
    }
    \item{\code{head(path, query, ...)}}{
      Make a HEAD request
    }
  }
}
\examples{
\dontrun{
(x <- HttpClient$new(url = "https://httpbin.org"))
x$url
(res_get1 <- x$get('get'))
res_get1$content
res_get1$response_headers
res_get1$parse()

(res_get2 <- x$get('get', query = list(hello = "world")))
res_get2$parse()
library("jsonlite")
jsonlite::fromJSON(res_get2$parse())

# post request
(res_post <- x$post('post', body = list(hello = "world")))

## empty body request
x$post('post')

# put request
(res_put <- x$put('put'))

# delete request
(res_delete <- x$delete('delete'))

# patch request
(res_patch <- x$patch('patch'))

# head request
(res_head <- x$head())

# set options on client initialization
(res <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(
    verbose = TRUE,
    useragent = "hello world"
  )
))
res$opts
res$get('get')

# set headers
(res <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(
    verbose = TRUE
  ),
  headers = list(
    a = "stuff",
    b = "things"
  )
))
res$headers
# reassign header value
res$headers$a <- "that"
# define new header
res$headers$c <- "what"
# request
res$get('get')


# handles - pass in your own handle
h <- handle("https://httpbin.org")
(res <- HttpClient$new(handle = h))
out <- res$get("get")
}
}
\keyword{datasets}

