% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestTDsamples-class}
\alias{NextBestTDsamples-class}
\alias{.NextBestTDsamples}
\alias{NextBestTDsamples}
\alias{.DefaultNextBestTDsamples}
\title{\code{NextBestTDsamples}}
\usage{
NextBestTDsamples(prob_target_drt, prob_target_eot, derive)

.DefaultNextBestTDsamples()
}
\arguments{
\item{prob_target_drt}{(\code{proportion})\cr see slot definition in \code{\link{NextBestTD}}.}

\item{prob_target_eot}{(\code{proportion})\cr see slot definition in \code{\link{NextBestTD}}.}

\item{derive}{(\code{function})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{NextBestTDsamples}} is the class to find a next best dose based on Pseudo
DLT model with samples. Namely, it is to find two next best doses, one
for allocation during the trial and the second for final recommendation at
the end of a trial. Hence, there are two target probabilities of the
occurrence of a DLT that must be specified: target probability to be used
during the trial and target probability to be used at the end of the trial.
}
\section{Slots}{

\describe{
\item{\code{derive}}{(\code{function})\cr derives, based on a vector of posterior dose
samples, the target dose that has the probability of the occurrence of
DLT equals to either the \code{prob_target_drt} or \code{prob_target_eot}. It must
therefore accept one and only one argument, which is a numeric vector, and
return a number.}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestTDsamples()} function.
}
\examples{
# Target probability of the occurrence of a DLT during the trial is set to 0.35.
# Target probability of the occurrence of a DLT at the end of the trial is set to 0.3.
# We want the use the 30\% posterior quantile (the 30th percentile) of the TD35
# (the dose level with probability of the DLT equals 0.35) and TD30 samples.
my_next_best <- NextBestTDsamples(
  prob_target_drt = 0.35,
  prob_target_eot = 0.3,
  derive = function(samples) {
    as.numeric(quantile(samples, probs = 0.3))
  }
)
}
