% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsRelativeDLTCurrent-class}
\alias{IncrementsRelativeDLTCurrent-class}
\alias{.IncrementsRelativeDLTCurrent}
\alias{IncrementsRelativeDLTCurrent}
\alias{.DefaultIncrementsRelativeDLTCurrent}
\title{\code{IncrementsRelativeDLTCurrent}}
\usage{
IncrementsRelativeDLTCurrent(intervals = c(0L, 1L), increments = c(2L, 1L))

.DefaultIncrementsRelativeDLTCurrent()
}
\arguments{
\item{intervals}{(\code{numeric})\cr see slot definition.}

\item{increments}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{IncrementsRelativeDLTCurrent}} is the class for increments control based on
relative differences and current DLTs. The class is based on the number of
DLTs observed in the current cohort, but not cumulatively over all cohorts
so far.
}
\note{
Typically, end users will not use the \code{.DefaultIncrementsRelativeDLTCurrent()} function.
}
\examples{
# As example, here is the rule for:
# maximum doubling the dose if no DLTs were observed at the current dose
# or maximum increasing the dose by 1.33 if 1 or 2 DLTs were observed at the current dose
# or maximum increasing the dose by 1.22 if 3 or more DLTs were observed.

my_increments <- IncrementsRelativeDLTCurrent(
  intervals = c(0, 1, 3),
  increments = c(1, 0.33, 0.2)
)
}
\seealso{
\link{IncrementsRelativeDLT}.
}
