% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\docType{methods}
\name{update,LogisticIndepBeta-method}
\alias{update,LogisticIndepBeta-method}
\title{Update method for the 'LogisticIndepBeta'Model class. This is a method to update the modal
estimates of the model parameters \eqn{\phi_1} (phi1) and \eqn{\phi_2} (phi2) when new data 
or new observations of responses are available and added in.}
\usage{
\S4method{update}{LogisticIndepBeta}(object, data, ...)
}
\arguments{
\item{object}{the model of \code{\linkS4class{LogisticIndepBeta}} class object}

\item{data}{all currently availabvle of \code{\linkS4class{Data}} class object}

\item{\dots}{unused}
}
\value{
the new \code{\linkS4class{LogisticIndepBeta}} class object
}
\description{
Update method for the 'LogisticIndepBeta'Model class. This is a method to update the modal
estimates of the model parameters \eqn{\phi_1} (phi1) and \eqn{\phi_2} (phi2) when new data 
or new observations of responses are available and added in.
}
\examples{
##Update the 'LogisticIndepBeta' model with new data
## first define the data and the model
emptydata<-Data(doseGrid=seq(25,300,25))
data<-emptydata

model<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)
##Then we have some new observations data
data<-Data(x=c(25,50,50,75,100,100,225,300),
           y=c(0,0,0,0,1,1,1,1),
           doseGrid=seq(from=25,to=300,by=25))
##update the model to get new estimates
newModel <- update(object=model,data=data)
}
\keyword{methods}

