% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_group.R
\name{crew_class_controller_group}
\alias{crew_class_controller_group}
\title{Controller group class}
\description{
\code{R6} class for controller groups.
}
\details{
See \code{\link[=crew_controller_group]{crew_controller_group()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
persistent <- crew_controller_local(name = "persistent")
transient <- crew_controller_local(
  name = "transient",
  tasks_max = 1L
)
group <- crew_controller_group(persistent, transient)
group$start()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$terminate()
}

## ------------------------------------------------
## Method `crew_class_controller_group$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
persistent <- crew_controller_local(name = "persistent")
transient <- crew_controller_local(
  name = "transient",
  tasks_max = 1L
)
group <- crew_controller_group(persistent, transient)
group$start()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$terminate()
}
}
\seealso{
Other controllers: 
\code{\link{crew_class_controller}},
\code{\link{crew_controller_group}()},
\code{\link{crew_controller_local}()},
\code{\link{crew_controller}()}
}
\concept{controllers}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{controllers}}{List of \code{R6} controller objects.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_controller_group-new}{\code{crew_class_controller_group$new()}}
\item \href{#method-crew_class_controller_group-validate}{\code{crew_class_controller_group$validate()}}
\item \href{#method-crew_class_controller_group-empty}{\code{crew_class_controller_group$empty()}}
\item \href{#method-crew_class_controller_group-saturated}{\code{crew_class_controller_group$saturated()}}
\item \href{#method-crew_class_controller_group-start}{\code{crew_class_controller_group$start()}}
\item \href{#method-crew_class_controller_group-launch}{\code{crew_class_controller_group$launch()}}
\item \href{#method-crew_class_controller_group-scale}{\code{crew_class_controller_group$scale()}}
\item \href{#method-crew_class_controller_group-push}{\code{crew_class_controller_group$push()}}
\item \href{#method-crew_class_controller_group-collect}{\code{crew_class_controller_group$collect()}}
\item \href{#method-crew_class_controller_group-pop}{\code{crew_class_controller_group$pop()}}
\item \href{#method-crew_class_controller_group-wait}{\code{crew_class_controller_group$wait()}}
\item \href{#method-crew_class_controller_group-summary}{\code{crew_class_controller_group$summary()}}
\item \href{#method-crew_class_controller_group-terminate}{\code{crew_class_controller_group$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-new}{}}}
\subsection{Method \code{new()}}{
Multi-controller constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$new(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{List of \code{R6} controller objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the controller group object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
persistent <- crew_controller_local(name = "persistent")
transient <- crew_controller_local(
  name = "transient",
  tasks_max = 1L
)
group <- crew_controller_group(persistent, transient)
group$start()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the router.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-empty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-empty}{}}}
\subsection{Method \code{empty()}}{
See if the controllers are empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$empty(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is empty if it has no running tasks
or completed tasks waiting to be retrieved with \code{push()}.
}

\subsection{Returns}{
\code{TRUE} if all the selected controllers are empty,
\code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-saturated"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-saturated}{}}}
\subsection{Method \code{saturated()}}{
Check if a controller is saturated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$saturated(
  collect = TRUE,
  throttle = TRUE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collect}}{Logical of length 1, whether to collect the results
of any newly resolved tasks before determining saturation.}

\item{\code{throttle}}{Logical of length 1, whether to delay task collection
until the next request at least \code{self$router$seconds_interval}
seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controller}}{Character vector of length 1 with the controller name.
Set to \code{NULL} to select the default controller that \code{push()}
would choose.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is saturated if the number of unresolved tasks
is greater than or equal to the maximum number of workers.
In other words, in a saturated controller, every available worker
has a task.
You can still push tasks to a saturated controller, but
tools that use \code{crew} such as \code{targets} may choose not to.
}

\subsection{Returns}{
\code{TRUE} if all the selected controllers are saturated,
\code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-start}{}}}
\subsection{Method \code{start()}}{
Start one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$start(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-launch}{}}}
\subsection{Method \code{launch()}}{
Launch one or more workers on one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$launch(n = 1L, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of workers to launch in each controller selected.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-scale}{}}}
\subsection{Method \code{scale()}}{
Automatically scale up the number of workers if needed
in one or more controller objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$scale(throttle = FALSE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{Logical of length 1, whether to delay auto-scaling
until the next auto-scaling request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the \code{scale()} method in individual controller classes.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-push}{}}}
\subsection{Method \code{push()}}{
Push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$push(
  command,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = sample.int(n = 1000000000L, size = 1L),
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  scale = TRUE,
  throttle = TRUE,
  name = NULL,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task. See the \code{reset_globals}
argument of \code{\link[=crew_controller_local]{crew_controller_local()}}.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to temporarily set for the evaluation of the task.
At the end of the task, the seed is restored.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand.
If \code{TRUE}, then \code{collect()} runs first
so demand can be properly assessed before scaling and the number
of workers is not too high.}

\item{\code{throttle}}{If \code{scale} is \code{TRUE}, whether to defer auto-scaling
until the next auto-scaling request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{name}}{Optional name of the task. Replaced with a random name
if \code{NULL} or in conflict with an existing name in the task list.}

\item{\code{controller}}{Character of length 1,
name of the controller to submit the task.
If \code{NULL}, the controller defaults to the
first controller in the list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-collect}{}}}
\subsection{Method \code{collect()}}{
Check for done tasks and move the results to
the results list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$collect(throttle = FALSE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{whether to defer task collection
until the next task collection request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly). Removes elements from the \code{queue}
list as applicable and moves them to the \code{results} list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a completed task from the results data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$pop(
  scale = TRUE,
  collect = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand.
If \code{TRUE}, then \code{collect()} runs first
so demand can be properly assessed before scaling and the number
of workers is not too high. Scaling up on \code{pop()} may be important
for transient or nearly transient workers that tend to drop off
quickly after doing little work.}

\item{\code{collect}}{Logical of length 1. If \code{scale} is \code{FALSE},
whether to call \code{collect()}
to pick up the results of completed tasks. This task collection
step always happens (with throttling) when \code{scale} is \code{TRUE}.}

\item{\code{throttle}}{If \code{scale} is \code{TRUE}, whether to defer auto-scaling
until the next auto-scaling request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If there is a completed task available to collect, the return
value is a one-row data frame with the results, warnings, and errors.
Otherwise, if there are no results available to collect,
the return value is \code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-wait}{}}}
\subsection{Method \code{wait()}}{
Wait for tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$wait(
  mode = "all",
  seconds_interval = 0.01,
  seconds_timeout = Inf,
  scale = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{If \code{mode} is \code{"all"},
then the method waits for all tasks to complete. If \code{mode} is
\code{"one"}, then it waits until a one task is complete.}

\item{\code{seconds_interval}}{Number of seconds to wait between
polling intervals while checking for results.}

\item{\code{seconds_timeout}}{Timeout length in seconds waiting for
results to become available.}

\item{\code{scale}}{Logical of length 1, whether to call \code{scale_later()}
on each selected controller to schedule auto-scaling.
By design, auto-scaling might not actually happen on
every iteration if \code{throttle} is \code{TRUE}.}

\item{\code{throttle}}{If \code{scale} is \code{TRUE}, whether to defer auto-scaling
and task collection until the next request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.
Highly recommended to keep
the default \code{throttle = TRUE} for \code{wait()}.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{wait()} method blocks the calling R session,
repeatedly auto-scales workers for tasks
that need them, and repeatedly collects results.
The function runs until it either times out or one of the
controllers reaches the stopping condition
based on the \code{mode} argument.
}

\subsection{Returns}{
\code{NULL} (invisibly). Call \code{pop()} to get the result.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the workers of one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$summary(
  columns = tidyselect::everything(),
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{columns}}{Tidyselect expression to select a subset of columns.
Examples include \code{columns = contains("worker")} and
\code{columns = starts_with("tasks")}.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of aggregated worker summary statistics
of all the selected controllers. It has one row per worker
websocket, and the rows are grouped by controller.
See the documentation of the \code{summary()} method of the controller
class for specific information about the columns in the output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the workers and disconnect the router
for one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$terminate(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
