% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_sge.R
\name{crew_controller_sge}
\alias{crew_controller_sge}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}} Create a controller with a
Sun Grid Engine (SGE) launcher.}
\usage{
crew_controller_sge(
  name = NULL,
  workers = 1L,
  host = NULL,
  port = NULL,
  tls = crew::crew_tls(mode = "automatic"),
  tls_enable = NULL,
  tls_config = NULL,
  seconds_interval = 0.25,
  seconds_timeout = 10,
  seconds_launch = 86400,
  seconds_idle = Inf,
  seconds_wall = Inf,
  seconds_exit = NULL,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE,
  launch_max = 5L,
  verbose = FALSE,
  command_submit = as.character(Sys.which("qsub")),
  command_delete = as.character(Sys.which("qdel")),
  script_directory = tempdir(),
  script_lines = character(0L),
  sge_cwd = TRUE,
  sge_envvars = FALSE,
  sge_log_output = "/dev/null",
  sge_log_error = NULL,
  sge_log_join = TRUE,
  sge_memory_gigabytes_limit = NULL,
  sge_memory_gigabytes_required = NULL,
  sge_cores = NULL,
  sge_gpu = NULL
)
}
\arguments{
\item{name}{Name of the client object. If \code{NULL}, a name is automatically
generated.}

\item{workers}{Integer, maximum number of parallel workers to run.}

\item{host}{IP address of the \code{mirai} client to send and receive tasks.
If \code{NULL}, the host defaults to the local IP address.}

\item{port}{TCP port to listen for the workers. If \code{NULL},
then an available ephemeral port is automatically chosen.}

\item{tls}{A TLS configuration object from \code{\link[crew:crew_tls]{crew_tls()}}.}

\item{tls_enable}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{tls_config}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete,
such as checking \code{mirai::status()}}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::daemon()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::daemon()}.}

\item{seconds_exit}{Deprecated on 2023-09-21 in version 0.1.2.9000.
No longer necessary.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::daemon()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerstart} argument of \code{mirai::daemon()}.}

\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to unload any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.}

\item{garbage_collection}{\code{TRUE} to run garbage collection between
tasks, \code{FALSE} to skip.}

\item{launch_max}{Positive integer of length 1, maximum allowed
consecutive launch attempts which do not complete any tasks.
Enforced on a worker-by-worker basis.
The futile launch count resets to back 0
for each worker that completes a task.
It is recommended to set \code{launch_max} above 0
because sometimes workers are unproductive under perfectly ordinary
circumstances. But \code{launch_max} should still be small enough
to detect errors in the underlying platform.}

\item{verbose}{Logical, whether to see console output and error messages
when submitting worker.}

\item{command_submit}{Character of length 1,
file path to the executable to submit a worker job.}

\item{command_delete}{Character of length 1,
file path to the executable to delete a worker job.
Set to \code{""} to skip manually terminating the worker.
Unless there is an issue with the platform,
the job should still exit thanks to the NNG-powered network programming
capabilities of \code{mirai}. Still, if you set \code{command_delete = ""},
you are assuming extra responsibility for manually monitoring
your jobs on the cluster and manually terminating jobs as appropriate.}

\item{script_directory}{Character of length 1, directory path to the
job scripts. Just before each job submission, a job script
is created in this folder. Script base names are unique to each
launcher and worker, and the launcher deletes the script when the
worker is manually terminated. \code{tempdir()} is the default, but it
might not work for some systems.
\code{tools::R_user_dir("crew.cluster", which = "cache")}
is another reasonable choice.}

\item{script_lines}{Optional character vector of additional lines to be
added to the job script just after the more common flags.
An example would be \code{script_lines = "module load R"} if your cluster
supports R through an environment module.}

\item{sge_cwd}{Logical of length 1, whether to
launch the worker from the current working directory (as opposed to
the user home directory). \code{sge_cwd = TRUE} translates to a line of
\verb{#$ -cwd} in the SGE job script. \code{sge_cwd = FALSE} omits this line.}

\item{sge_envvars}{Logical of length 1, whether to forward the environment
variables of the current session to the SGE worker. \code{sge_envvars = TRUE}
translates to a line of \verb{#$ -V} in the SGE job script.
\code{sge_envvars = FALSE} omits this line.}

\item{sge_log_output}{Character of length 1, file or directory path to SGE
worker log files for standard output.
\code{sge_log_output = "VALUE"} translates to a line of
\verb{#$ -o VALUE} in the SGE job script. The default is \verb{/dev/null} to omit
the logs. If you do supply a non-\verb{/dev/null} value,
it is recommended to supply a
directory path with a trailing slash so that each worker gets its own set
of log files.}

\item{sge_log_error}{Character of length 1, file or directory path to SGE
worker log files for standard error.
\code{sge_log_error = "VALUE"} translates to a line of
\verb{#$ -e VALUE} in the SGE job script.
The default of \code{NULL} omits this line.
If you do supply a non-\verb{/dev/null} value, it is recommended to supply a
directory path with a trailing slash so that each worker gets its own set
of log files.}

\item{sge_log_join}{Logical, whether to join the stdout and stderr log
files together into one file. \code{sge_log_join = TRUE} translates to a line
of \verb{#$ -j y} in the SGE job script, while \code{sge_log_join = FALSE} is
equivalent to \verb{#$ -j n}. If \code{sge_log_join = TRUE}, then \code{sge_log_error}
should be \code{NULL}.}

\item{sge_memory_gigabytes_limit}{Optional numeric of length 1
with the maximum number of gigabytes of memory a worker is allowed to
consume. If the worker consumes more than this level of memory, then
SGE will terminate it. \verb{sge_memory_gigabytes_limit = 5.7"}
translates to a line of \code{"#$ -l h_rss=5.7G"} in the SGE job script.
\code{sge_memory_gigabytes_limit = NULL} omits this line.}

\item{sge_memory_gigabytes_required}{Optional positive numeric of length 1
with the gigabytes of memory required to run the worker.
\code{sge_memory_gigabytes_required = 2.4}
translates to a line of \verb{#$ -l m_mem_free=2.4G} in the SGE job script.
\code{sge_memory_gigabytes_required = NULL} omits this line.}

\item{sge_cores}{Optional positive integer of length 1,
number of cores per worker ("slots" in SGE lingo).
\code{sge_cores = 4} translates
to a line of \verb{#$ -pe smp 4} in the SGE job script.
\code{sge_cores = NULL} omits this line.}

\item{sge_gpu}{Optional integer of length 1 with the number of GPUs to
request for the worker. \code{sge_gpu = 1} translates to a line of
\code{"#$ -l gpu=1"} in the SGE job script. \code{sge_gpu = NULL} omits this line.}
}
\description{
Create an \code{R6} object to submit tasks and
launch workers on Sun Grid Engine (SGE) workers.
}
\section{Attribution}{

The template files at
\url{https://github.com/mschubert/clustermq/tree/master/inst}
informed the development of the \code{crew} launcher plugins in
\code{crew.cluster}, and we would like to thank
Michael Schubert for developing \code{clustermq} and releasing it under
the permissive Apache License 2.0.
See the \code{NOTICE} and \code{README.md} files in the \code{crew.cluster}
source code for additional attribution.
}

\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
controller <- crew_controller_sge()
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()$result
controller$terminate()
}
}
\seealso{
Other plugin_sge: 
\code{\link{crew_class_launcher_sge}},
\code{\link{crew_launcher_sge}()}
}
\concept{plugin_sge}
