% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_distribution}
\alias{plot_distribution}
\alias{plot_distribution_x}
\title{Plot Distribution}
\usage{
plot_distribution(
  dat,
  x_list = NULL,
  dir_path = tempdir(),
  breaks_list = NULL,
  g = 10,
  m = 3,
  cut_bin = "equal_width"
)

plot_distribution_x(
  dat,
  x,
  breaks = NULL,
  g = 10,
  m = 3,
  cut_bin = "equal_width",
  binwidth = NULL
)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{x_list}{Names of independent variables.}

\item{dir_path}{The path for periodically saved graphic files.}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{g}{Number of initial breakpoints for equal frequency binning.}

\item{m}{The outlier cutoff.}

\item{cut_bin}{A string, if equal_bins is TRUE, 'equal_depth' or 'equal_width', default is 'equal_depth'.}

\item{x}{The name of an independent variable.}

\item{breaks}{Splitting points for an independent variable. Default is NULL.}

\item{binwidth}{Windth of bins for histogram.}
}
\description{
You can use the \code{plot_distribution_x} to produce the distrbution plot of a variable.
You can use the \code{plot_distribution} to produce the plots of distrbutions of all variables.
}
\examples{
plot_distribution_x(dat = lendingclub, x = "max_bal_bc", g = 10,
	cut_bin = 'equal_width')
plot_distribution(dat = lendingclub, x_list = c("max_bal_bc", "installment"), 
     g = 10,dir_path = tempdir(),
	cut_bin = 'equal_width')
}
