% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependence_tree.R
\name{build_dependence_tree.cranly_network}
\alias{build_dependence_tree.cranly_network}
\alias{cranly_dependence_tree}
\title{Construct a \code{\link{cranly_dependence_tree}} object}
\usage{
\method{build_dependence_tree}{cranly_network}(x, package = Inf,
  base = FALSE, recommended = TRUE, global = TRUE, ...)
}
\arguments{
\item{x}{a \code{\link{cranly_network}} object}

\item{package}{a vector of character strings with the package names to be matched. Default is \code{Inf} which returns all available packages in \code{x} for further subsetting}

\item{base}{logical. Should we include base packages in the subset? Default is \code{TRUE}}

\item{recommended}{logical. Should we include recommended packages in the subset? Default is \code{TRUE}}

\item{global}{locical. If \code{TRUE} (default) the network summary statistics are computed on \code{object}, otherwise, on the subset of \code{object} according to \code{package}, \code{author}, \code{directive}, \code{base}, \code{recommended}}

\item{...}{currently not used}
}
\description{
Construct a \code{\link{cranly_dependence_tree}} object
}
\examples{
\dontrun{
cran_db <- clean_CRAN_db()
package_network <- build_network(object = cran_db)
dep_tree <- build_dependence_tree(package_network, package = "PlackettLuce")
plot(dep_tree)
}

}
\seealso{
compute_dependence_tree
}
