% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cranly-package.R, R/extractors.R
\name{package_by}
\alias{package_by}
\alias{package_with}
\alias{author_with}
\alias{author_of}
\alias{package_by.cranly_network}
\alias{author_of.cranly_network}
\alias{author_with.cranly_network}
\alias{package_with.cranly_network}
\title{Find packages and authors by authors or packages with names matching a specific string}
\usage{
package_by(x, author = NULL, exact = FALSE)

package_with(x, name = NULL, exact = FALSE)

author_with(x, name = NULL, exact = FALSE)

author_of(x, package = NULL, exact = FALSE)

\method{package_by}{cranly_network}(x, author = NULL, exact = FALSE)

\method{author_of}{cranly_network}(x, package = NULL, exact = FALSE)

\method{author_with}{cranly_network}(x, name = NULL, exact = FALSE)

\method{package_with}{cranly_network}(x, name = NULL, exact = FALSE)
}
\arguments{
\item{x}{a \code{\link{cranly_network}} object}

\item{author}{a vector of character strings with the author names to be matched}

\item{exact}{logical. Should we use exact matching? Default is \code{TRUE}}

\item{name}{a vector of character strings with the names to be matched}

\item{package}{a vector of character strings with the package names to be matched}
}
\description{
Find packages and authors by authors or packages with names matching a specific string
}
\examples{
\dontrun{
data("cran20032018", package = "cranly")
## Using a package directives network
package_network <- build_network(cran20032018)
## Find all packages containing glm in their name
package_with(package_network, name = "glm")
## Find all authors of packages containing brglm in their name
author_of(package_network, package = "rglm", exact = FALSE)
## Find all packages with brglm in their name
package_with(package_network, name = "rglm", exact = FALSE)
## Find all authors of the package brglm2
author_of(package_network, package = "brglm2", exact = TRUE)
## Find all authors with Ioannis in their name
author_with(package_network, name = "Ioannis", exact = TRUE)

## Using an author collaboration network
author_network <- build_network(cran20032018, perspective = "author")
## Find all packages containing glm in their name
package_with(author_network, name = "glm")
## Find all authors of packages containing brglm in their name
author_of(author_network, package = "rglm", exact = FALSE)
## Find all packages with brglm in their name
package_with(author_network, name = "rglm", exact = FALSE)
## Find all authors of the package brglm2
author_of(author_network, package = "brglm2", exact = TRUE)
## Find all authors with Ioannis in their name
author_with(author_network, name = "Ioannis", exact = TRUE)
}
}
