% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armed_bandit_helpers.R
\name{BatchContextualLinTSPolicy}
\alias{BatchContextualLinTSPolicy}
\title{Batch Contextual Thompson Sampling Policy}
\description{
Batch Contextual Thompson Sampling Policy

Batch Contextual Thompson Sampling Policy
}
\details{
Implements Thompson Sampling for linear contextual bandits with batch updates.
}
\section{Methods}{

- `initialize(v = 0.2, batch_size = 1)`: Constructor, sets variance and batch size.
- `set_parameters(context_params)`: Initializes arm-level matrices.
- `get_action(t, context)`: Samples from the posterior and selects action.
- `set_reward(t, context, action, reward)`: Updates posterior statistics using observed feedback.
}

\section{Super class}{
\code{cramR::NA}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sigma}}{Numeric, posterior variance scale parameter.}

\item{\code{batch_size}}{Integer, size of mini-batches before parameter updates.}

\item{\code{A_cc}}{List of accumulated Gram matrices per arm.}

\item{\code{b_cc}}{List of reward-weighted context sums per arm.}

\item{\code{class_name}}{Internal name of the class.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NA-new}{\code{BatchContextualLinTSPolicy$new()}}
\item \href{#method-NA-set_parameters}{\code{BatchContextualLinTSPolicy$set_parameters()}}
\item \href{#method-NA-get_action}{\code{BatchContextualLinTSPolicy$get_action()}}
\item \href{#method-NA-set_reward}{\code{BatchContextualLinTSPolicy$set_reward()}}
\item \href{#method-unknown-clone}{\code{BatchContextualLinTSPolicy$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="cramR" data-topic="NA" data-id="initialize_theta"><a href='../../cramR/html/NA.html#method-NA-initialize_theta'><code>cramR::NA$initialize_theta()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cramR" data-topic="NA" data-id="post_initialization"><a href='../../cramR/html/NA.html#method-NA-post_initialization'><code>cramR::NA$post_initialization()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-new"></a>}}
\if{latex}{\out{\hypertarget{method-NA-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the batch-based Thompson Sampling policy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualLinTSPolicy$new(v = 0.2, batch_size = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{Numeric. Standard deviation scaling parameter for posterior sampling.}

\item{\code{batch_size}}{Integer. Number of rounds before parameters are updated.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-set_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-NA-set_parameters}{}}}
\subsection{Method \code{set_parameters()}}{
Initializes per-arm sufficient statistics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualLinTSPolicy$set_parameters(context_params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context_params}}{List with entries: `unique` (feature vector), `k` (number of arms).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-get_action"></a>}}
\if{latex}{\out{\hypertarget{method-NA-get_action}{}}}
\subsection{Method \code{get_action()}}{
Samples from the posterior distribution of expected rewards and selects an action.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualLinTSPolicy$get_action(t, context)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{Integer. Time step.}

\item{\code{context}}{List containing the current context and arm information.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the chosen arm (`choice`).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-set_reward"></a>}}
\if{latex}{\out{\hypertarget{method-NA-set_reward}{}}}
\subsection{Method \code{set_reward()}}{
Updates Gram matrix and response vector for the chosen arm.
Parameters are refreshed every `batch_size` rounds.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualLinTSPolicy$set_reward(t, context, action, reward)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{Integer. Time step.}

\item{\code{context}}{Context object containing feature info.}

\item{\code{action}}{Chosen action (arm index).}

\item{\code{reward}}{Observed reward for the action.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated internal parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unknown-clone"></a>}}
\if{latex}{\out{\hypertarget{method-unknown-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualLinTSPolicy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
