% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibullfns.R
\name{weib_cdfsim}
\alias{weib_cdfsim}
\title{Inverse CDF simulation for the Weibull change-point hazard distribution}
\usage{
weib_cdfsim(n, endtime, gamma, theta, tau = NA)
}
\arguments{
\item{n}{Sample size}

\item{endtime}{Maximum study time, point at which all participants
are censored}

\item{gamma}{Shape parameter \eqn{\gamma}}

\item{theta}{Scale parameter \eqn{\theta}}

\item{tau}{Change-point(s) \eqn{\tau}}
}
\value{
Dataset with n participants including a survival time
and censoring indicator (0 = censored, 1 = event).
}
\description{
\code{weib_cdfsim} simulates time-to-event data from the Weibull change-point
hazard distribution by implementing the inverse CDF method.
}
\details{
This function simulates data from the Weibull change-point hazard distribution
with \eqn{K} change-points by simulating values of the exponential distribution and
substituting them into the inverse hazard function. This method applies Type I
right censoring at the endtime specified by the user. This function allows for
up to four change-points and \eqn{\gamma} is held constant.
}
\examples{
nochangepoint <- weib_cdfsim(n = 10, endtime = 20, gamma = 2,
  theta = 0.5)
onechangepoint <- weib_cdfsim(n = 10, endtime = 20, gamma = 2,
  theta = c(0.05, 0.01), tau = 10)
twochangepoints <- weib_cdfsim(n = 10, endtime = 20, gamma = 2,
  theta = c(0.05, 0.01, 0.05), tau = c(8, 12))

}
