% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiggle.R
\name{wiggle}
\alias{wiggle}
\title{Wiggliness of a Spline function}
\usage{
wiggle(object, lower, upper, stop.on.error = FALSE, ...)
}
\arguments{
\item{object}{a \code{cpr_cp} object}

\item{lower}{the lower limit of the integral}

\item{upper}{the upper limit of the integral}

\item{stop.on.error}{default to \code{FALSE}, see \code{\link[stats]{integrate}}.}

\item{...}{additional arguments passed to \code{\link[stats]{integrate}}}
}
\value{
Same as \code{\link[stats]{integrate}}.
}
\description{
Calculate the integral of the squared second derivative of the spline
function.
}
\details{
The wiggliness of the spline function is defined as

\deqn{\int \left( \frac{\mathrm{d}^2}{\mathrm{d}x^2} f \left(x \right)
\right)^2 \mathrm{d}x.}{ \int (d^2 / dx^2 f(x))^2 dx}
}
\examples{
xvec <- seq(0, 6, length = 500)

# Define the basis matrix
bmat1 <- bsplines(x = xvec, iknots = c(1, 1.5, 2.3, 4, 4.5))
bmat2 <- bsplines(x = xvec)

# Define the control vertices ordinates
theta1 <- c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5)
theta2 <- c(1, 3.4, -2, 1.7)

# build the two control polygons
cp1 <- cp(bmat1, theta1)
cp2 <- cp(bmat2, theta2)
plot(cp1, cp2, show_cp = FALSE, show_spline = TRUE)

wiggle(cp1)
wiggle(cp2)

}
\seealso{
\code{\link{cp}}, \code{\link[stats]{integrate}},
\code{\link{sign_changes}}
}
