% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp.R
\name{cp}
\alias{cp}
\alias{cp.cpr_bs}
\alias{cp.formula}
\alias{print.cpr_cp}
\alias{summary.cpr_cp}
\alias{plot.cpr_cp}
\title{Control Polygons}
\usage{
cp(x, ...)

\method{cp}{cpr_bs}(x, theta, ...)

\method{cp}{formula}(formula, data, method = stats::lm, ..., keep_fit = FALSE, check_rank = TRUE)

\method{print}{cpr_cp}(x, ...)

\method{summary}{cpr_cp}(object, wiggle = FALSE, integrate.args = list(), ...)

\method{plot}{cpr_cp}(
  x,
  ...,
  show_cp = TRUE,
  show_spline = FALSE,
  show_xi = TRUE,
  color = FALSE,
  n = 100
)
}
\arguments{
\item{x}{a \code{cpr_bs} object}

\item{...}{arguments passed to the regression method}

\item{theta}{a vector of (regression) coefficients, the ordinates of the
control polygon.}

\item{formula}{a formula that is appropriate for regression method being
used.}

\item{data}{a required \code{data.frame}}

\item{method}{the regression method such as \code{\link[stats]{lm}},
\code{\link[stats]{glm}}, \code{\link[lme4]{lmer}}, etc.}

\item{keep_fit}{(logical, default value is \code{FALSE}).  If \code{TRUE} the
regression model fit is retained and returned in as the \code{fit} element.
If \code{FALSE} the \code{fit} element with be \code{NA}.}

\item{check_rank}{(logical, defaults to \code{TRUE}) if \code{TRUE} check
that the design matrix is full rank.}

\item{object}{a \code{cpr_cp} object}

\item{wiggle}{logical, if \code{TRUE} then the integral of the squared second
derivative of the spline function will be calculated via
\code{stats::integrate}.}

\item{integrate.args}{a list of arguments passed to \code{cpr::wiggle} and
ultimately \code{stats::integrate}.}

\item{show_cp}{logical (default \code{TRUE}), show the control polygon(s)?}

\item{show_spline}{logical (default \code{FALSE}) to plot the spline
function?}

\item{show_xi}{logical (default \code{TRUE}) use
\code{\link[ggplot2]{geom_rug}} to show the location of the knots in the
respective control polygons.}

\item{color}{Boolean (default FALSE) if more than one \code{cpr_cp} object is
to be plotted, set this value to TRUE to have the graphic in color (line types
will be used regardless of the color setting).}

\item{n}{the number of data points to use for plotting the spline}
}
\description{
Generate the control polygon for a uni-variable B-spline
}
\details{
\code{cp} generates the control polygon for the given B-spline function.
}
\examples{

# Support
xvec <- seq(0, 6, length = 500)

# Define the basis matrix
bmat1 <- cpr::bsplines(x = xvec, iknots = c(1, 1.5, 2.3, 4, 4.5))
bmat2 <- cpr::bsplines(x = xvec)

# Define the control vertices ordinates
theta1 <- c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5)
theta2 <- c(1, 3.4, -2, 1.7)

# build the two control polygons
cp1 <- cp(bmat1, theta1)
cp2 <- cp(bmat2, theta2)

# black and white plot
plot(cp1)
plot(cp1, show_spline = TRUE)

# multiple control polygons
plot(cp1, cp2, show_spline = TRUE)
plot(cp1, cp2, color = TRUE)
plot(cp1, cp2, show_spline = TRUE, color = TRUE)

# via formula
dat <- data.frame(x = xvec, y = sin((xvec - 2)/pi) + 1.4 * cos(xvec/pi))
cp3 <- cp(y ~ cpr::bsplines(x), data = dat)

# plot the control polygon, spline and target data.
plot(cp3, show_spline = TRUE) +
  ggplot2::geom_line(mapping = ggplot2::aes(x = x, y = y),
                     data = dat, linetype = 2, color = "red")

}
