# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Knot Insertion, Removal, and Reinsertion
#'
#' Functions for the insertion, removal, and reinsertion of internal knots for
#' B-splines.
#'
#' \code{refine_ordinate} provides the estimated ordinates of the control
#' polygon's vertex sequence after inserting the value \code{x} into the knot
#' vector \code{xi}.
#'
#' \code{coarsen_ordinate} provides the estimated ordinates of the control
#' polygon's vertex sequence after the removal of the the value \code{x} from the
#' knot vector \code{xi}.  The expected input for this function is the value
#' \code{x} to insert into \code{xi}.  That is, to find the estimate of the
#' coarsened ordinates by removing the value 2 from the vector (0, 0, 0, 0, 1,
#' 2, 3, 4, 4, 4, 4) (the knot vector for a cubic B-spline with boundary knots
#' at zero and four and internal knots 1, 2, 3) should be specified by
#' \code{coarsen_ordinate(x = 2, xi = c(0, 0, 0, 0, 1, 3, 4, 4, 4, 4), theta)}.
#'
#' The function \code{hat_ordinate} is the coarsen-then-refine estimate of the
#' ordinate vector.  The name comes from the the use of a hat matrix based on the
#' in knot insertion matrix.
#'
#' Examples for the \code{refine_ordinate}, \code{coarsen_ordinate}, and
#' \code{hat_ordinate} are best shown in the vignette,
#' \code{vignette("cpr-pkg", package = "cpr")}.
#'
#' \code{iknot_weights} returns a vector with the 'importance weight' of each
#' of the internal knots in \code{xi}.
#'
#' @param x the value of the knot to be inserted into the knot vector
#' @param xi the (whole) knot vector, including the repeated boundary knots.
#'   Regardless of refinement or coarsening, this vector should be the
#'   'reduced' vector such that x will be added to it.  See details and
#'   examples.
#' @param theta the ordinates of the control polygon vertices
#' @param order the order of the B-spline, defaults to 4 for cubic splines
#'
#' @return numeric vectors
#'
#' @examples
#' \dontrun{
#' # See the vignette
#' vignette("cpr-pkg", package = "cpr")
#' }
#'
#' @export
#' @rdname boehm
refine_ordinate <- function(x, xi, theta, order = 4L) {
    .Call(`_cpr_refine_ordinate`, x, xi, theta, order)
}

#' @export
#' @rdname boehm
coarsen_ordinate <- function(x, xi, theta, order = 4L) {
    .Call(`_cpr_coarsen_ordinate`, x, xi, theta, order)
}

#' @export
#' @rdname boehm
hat_ordinate <- function(x, xi, theta, order = 4L) {
    .Call(`_cpr_hat_ordinate`, x, xi, theta, order)
}

#' @export
#' @rdname boehm
insertion_matrix <- function(x, xi, order = 4L) {
    .Call(`_cpr_insertion_matrix`, x, xi, order)
}

weigh_iknots <- function(xi, theta, order = 4L, p = 2L) {
    .Call(`_cpr_weigh_iknots`, xi, theta, order, p)
}

bbasis__impl <- function(x, iknots, bknots, order) {
    .Call(`_cpr_bbasis__impl`, x, iknots, bknots, order)
}

bsplineD1__impl <- function(x, j, order, knots) {
    .Call(`_cpr_bsplineD1__impl`, x, j, order, knots)
}

bsplineD2__impl <- function(x, j, order, knots) {
    .Call(`_cpr_bsplineD2__impl`, x, j, order, knots)
}

diag_only <- function(A, B) {
    .Call(`_cpr_diag_only`, A, B)
}

#' Rank of a Matrix
#'
#' Determine the rank (number of linearly independent columns) of a matrix.
#'
#' Implementation via the Armadillo C++ linear algebra library.  The function
#' returns the rank of the matrix \code{x}.  The computation is based on the
#' singular value decomposition of the matrix; a std::runtime_error exception
#' will be thrown if the decomposition fails.  Any singular values less than
#' the tolerance are treated as zeros.  The tolerance is
#' \code{max(m, n) * max_sv * arma::datum::eps}, where \code{m} is the number
#' of rows of \code{x}, \code{n} is the number of columns of \code{x},
#' \code{max_sv} is the maximal singular value of \code{x}, and
#' \code{arma::datum::eps} is the difference between 1 and the least value
#' greater than 1 that is representable.
#'
#' @param x a numeric matrix
#'
#' @return
#' the rank of the matrix as a numeric value.
#'
#' @examples
#' # Check the rank of a matrix
#' set.seed(42)
#' mat <- matrix(rnorm(25000 * 120), nrow = 25000)
#' matrix_rank(mat) == ncol(mat)
#' matrix_rank(mat) == 120L
#'
#' # A full rank B-spline basis
#' bmat <- bsplines(seq(0, 1, length = 100), df = 15)
#' matrix_rank(bmat) == 15L
#'
#' # A rank deficient B-spline basis
#' bmat <- bsplines(seq(0, 1, length = 100), iknots = c(0.001, 0.002))
#' ncol(bmat) == 6L
#' matrix_rank(bmat) == 5L
#'
#' @references
#'
#' Conrad Sanderson and Ryan Curtin.  Armadillo: a template-based C++ library
#' for linear algebra.  Journal of Open Source Software, Vol. 1, pp. 26, 2016.
#'
#' @export
matrix_rank <- function(x) {
    .Call(`_cpr_matrix_rank`, x)
}

tp__impl <- function(A, B) {
    .Call(`_cpr_tp__impl`, A, B)
}

