% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spline.R
\name{get_spline}
\alias{get_spline}
\title{Get the Control Polygon and the Spline Function}
\usage{
get_spline(x, margin = 1, at, n = 100)
}
\arguments{
\item{x}{a \code{cpr_cp} or \code{cpr_cn} object.}

\item{margin}{an integer identifying the marginal of the control net to slice
along.  Only used when working \code{x} is a \code{cpr_cn} object.}

\item{at}{point value for marginals not defined in the \code{margin}.  Only
used when \code{x} is a \code{cpr_cn} object.  Expected input is a list of
length \code{length(attr(x, "bspline_list"))}.  Entries for elements
\code{marginal} are ignored.  If omitted, the midpoint between the boundary
knots for each marginal is used.}

\item{n}{the length of sequence to use for interpolating the spline function.}
}
\description{
Generate \code{data.frame}s for interpolating and plotting a spline
function, given a \code{cpr_cp} or \code{cpr_cn} object.
}
\details{
A control polygon, \code{cpr\_cp} object, has a spline function f(x).
\code{get_spline} returns a list of two \code{data.frame}.  The \code{cp}
element is a \code{data.frame} with the (x, y) coordinates control points and
the \code{spline} element is a \code{data.frame} with \code{n} rows for
interpolating f(x).

For a control net, \code{cpr\_cn} object, the return is the same as for a
\code{cpr\_cp} object, but conceptually different.  Where a \code{cpr\_cp}
objects have a uni-variable spline function, \code{cpr\_cn} have
multi-variable spline surfaces.  \code{get_spline} returns a "slice" of the
higher dimensional object.  For example, consider a three-dimensional control
net defined on the unit cube with marginals \code{x1}, \code{x2}, and
\code{x3}.  The implied spline surface is the function f(x1, x2, x3).
\code{get_spline(x, margin = 2, at = list(0.2, NA, 0.5))} would
return the control polygon and spline surface for f(0.2, x, 0.5).

See \code{\link{get_surface}} for taking a two-dimensional slice of a
three-plus dimensional control net, or, for generating a useful data set for
plotting the surface of a two-dimensional control net.
}
\examples{
data(spdg, package = "cpr")

## Extract the control polygon and spline for plotting.  We'll use base R
## graphics for this example.
a_cp <- cp(pdg ~ bsplines(day, df = 10), data = spdg)

cp_and_spline <- get_spline(a_cp)
plot(cp_and_spline$cp, type = "b")
points(cp_and_spline$spline, type = "l")
grid()

# compare to the cpr:::plot.cpr_cp method
plot(a_cp, show_spline = TRUE)

}
\seealso{
\code{\link{get_surface}}
}
\author{
Peter DeWitt \email{dewittpe@gmail.com}
}
