# vector
testthat::test_that("vector resize integer", {
  v <- cpp_vector(4:6)
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(4:6, rep.int(0L, 3L)))
  testthat::expect_invisible(resize(v, 8, 1L))
  testthat::expect_equal(to_r(v), c(4:6, rep.int(0L, 3L), rep.int(1L, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), 4:6)
})
testthat::test_that("vector resize double", {
  v <- cpp_vector(seq.int(1, 2, 0.5))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(seq.int(1, 2, 0.5), rep.int(0, 3L)))
  testthat::expect_invisible(resize(v, 8, 1))
  testthat::expect_equal(to_r(v), c(seq.int(1, 2, 0.5), rep.int(0, 3L), rep.int(1, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
})
testthat::test_that("vector resize string", {
  v <- cpp_vector(c("hello", "there", "world"))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(c("hello", "there", "world"), rep.int("", 3L)))
  testthat::expect_invisible(resize(v, 8, "package"))
  testthat::expect_equal(to_r(v), c(c("hello", "there", "world"), rep.int("", 3L), rep.int("package", 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
})
testthat::test_that("vector resize boolean", {
  v <- cpp_vector(c(TRUE, FALSE, FALSE))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(c(TRUE, FALSE, FALSE), rep.int(FALSE, 3L)))
  testthat::expect_invisible(resize(v, 8, TRUE))
  testthat::expect_equal(to_r(v), c(c(TRUE, FALSE, FALSE), rep.int(FALSE, 3L), rep.int(TRUE, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE, FALSE))
})

# deque
testthat::test_that("deque resize integer", {
  v <- cpp_deque(4:6)
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(4:6, rep.int(0L, 3L)))
  testthat::expect_invisible(resize(v, 8, 1L))
  testthat::expect_equal(to_r(v), c(4:6, rep.int(0L, 3L), rep.int(1L, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), 4:6)
})
testthat::test_that("deque resize double", {
  v <- cpp_deque(seq.int(1, 2, 0.5))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(seq.int(1, 2, 0.5), rep.int(0, 3L)))
  testthat::expect_invisible(resize(v, 8, 1))
  testthat::expect_equal(to_r(v), c(seq.int(1, 2, 0.5), rep.int(0, 3L), rep.int(1, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
})
testthat::test_that("deque resize string", {
  v <- cpp_deque(c("hello", "there", "world"))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(c("hello", "there", "world"), rep.int("", 3L)))
  testthat::expect_invisible(resize(v, 8, "package"))
  testthat::expect_equal(to_r(v), c(c("hello", "there", "world"), rep.int("", 3L), rep.int("package", 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
})
testthat::test_that("deque resize boolean", {
  v <- cpp_deque(c(TRUE, FALSE, FALSE))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(c(TRUE, FALSE, FALSE), rep.int(FALSE, 3L)))
  testthat::expect_invisible(resize(v, 8, TRUE))
  testthat::expect_equal(to_r(v), c(c(TRUE, FALSE, FALSE), rep.int(FALSE, 3L), rep.int(TRUE, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE, FALSE))
})

# forward_list
testthat::test_that("forward_list resize integer", {
  v <- cpp_forward_list(4:6)
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(4:6, rep.int(0L, 3L)))
  testthat::expect_invisible(resize(v, 8, 1L))
  testthat::expect_equal(to_r(v), c(4:6, rep.int(0L, 3L), rep.int(1L, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), 4:6)
})
testthat::test_that("forward_list resize double", {
  v <- cpp_forward_list(seq.int(1, 2, 0.5))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(seq.int(1, 2, 0.5), rep.int(0, 3L)))
  testthat::expect_invisible(resize(v, 8, 1))
  testthat::expect_equal(to_r(v), c(seq.int(1, 2, 0.5), rep.int(0, 3L), rep.int(1, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
})
testthat::test_that("forward_list resize string", {
  v <- cpp_forward_list(c("hello", "there", "world"))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(c("hello", "there", "world"), rep.int("", 3L)))
  testthat::expect_invisible(resize(v, 8, "package"))
  testthat::expect_equal(to_r(v), c(c("hello", "there", "world"), rep.int("", 3L), rep.int("package", 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
})
testthat::test_that("forward_list resize boolean", {
  v <- cpp_forward_list(c(TRUE, FALSE, FALSE))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(c(TRUE, FALSE, FALSE), rep.int(FALSE, 3L)))
  testthat::expect_invisible(resize(v, 8, TRUE))
  testthat::expect_equal(to_r(v), c(c(TRUE, FALSE, FALSE), rep.int(FALSE, 3L), rep.int(TRUE, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE, FALSE))
})

# list
testthat::test_that("list resize integer", {
  v <- cpp_list(4:6)
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(4:6, rep.int(0L, 3L)))
  testthat::expect_invisible(resize(v, 8, 1L))
  testthat::expect_equal(to_r(v), c(4:6, rep.int(0L, 3L), rep.int(1L, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), 4:6)
})
testthat::test_that("list resize double", {
  v <- cpp_list(seq.int(1, 2, 0.5))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(seq.int(1, 2, 0.5), rep.int(0, 3L)))
  testthat::expect_invisible(resize(v, 8, 1))
  testthat::expect_equal(to_r(v), c(seq.int(1, 2, 0.5), rep.int(0, 3L), rep.int(1, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
})
testthat::test_that("list resize string", {
  v <- cpp_list(c("hello", "there", "world"))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(c("hello", "there", "world"), rep.int("", 3L)))
  testthat::expect_invisible(resize(v, 8, "package"))
  testthat::expect_equal(to_r(v), c(c("hello", "there", "world"), rep.int("", 3L), rep.int("package", 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
})
testthat::test_that("list resize boolean", {
  v <- cpp_list(c(TRUE, FALSE, FALSE))
  testthat::expect_invisible(resize(v, 6))
  testthat::expect_equal(to_r(v), c(c(TRUE, FALSE, FALSE), rep.int(FALSE, 3L)))
  testthat::expect_invisible(resize(v, 8, TRUE))
  testthat::expect_equal(to_r(v), c(c(TRUE, FALSE, FALSE), rep.int(FALSE, 3L), rep.int(TRUE, 2L)))
  testthat::expect_invisible(resize(v, 3))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE, FALSE))
})
