% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ahmad2015.R, R/Chen2010.R,
%   R/DocumentStructureStatistics.R, R/Fisher2012.R, R/LedoitWolf2002.R,
%   R/Nagao1973.R, R/Srivastava2005.R, R/Srivastava2011.R
\name{Ahmad2015}
\alias{Ahmad2015}
\alias{Chen2010}
\alias{structureStatistics}
\alias{Fisher2012}
\alias{LedoitWolf2002}
\alias{Nagao1973}
\alias{Srivastava2005}
\alias{Srivastava2011}
\title{Tests for Structure of Covariance Matrices}
\usage{
Ahmad2015(x, Sigma = "identity", ...)

Chen2010(x, Sigma = "identity", ...)

Fisher2012(x, Sigma = "identity", ...)

LedoitWolf2002(x, Sigma = "identity", ...)

Nagao1973(x, Sigma = "identity", ...)

Srivastava2005(x, Sigma = "identity", ...)

Srivastava2011(x, Sigma = "identity", ...)
}
\arguments{
\item{x}{data as a list of matrices}

\item{Sigma}{Population covariance matrix as a matrix}

\item{...}{other options passed to covTest method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of equality of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of equality of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Performs Tests for the structure of covariance matrices.
}
\examples{
Chen2010(as.matrix(iris[1:50, 1:3]))
}
\references{
Ahmad, M. R. and Rosen, D. von. (2015). Tests for 
High-Dimensional Covariance Matrices Using the Theory of U-statistics. 
Journal of Statistical Computation and Simulation, 85(13), 2619-2631. 
\href{http://doi.org/10.1080/00949655.2014.948441}{10.1080/00949655.2014.948441}

Chen, S., et al. (2010). Tests for High-Dimensional 
Covariance Matrices. Journal of the American Statistical Association, 
105(490):810-819. \href{http://doi.org/10.1198/jasa.2010.tm09560}{10.1198/jasa.2010.tm09560}

Fisher, T. J. (2012). On Testing for an Identity 
Covariance Matrix when the Dimensionality Equals or Exceeds the 
Sample Size. Journal of Statistical Planning and Infernece, 142(1), 
312-326. \href{http://doi.org/10.1016/j.jspi.2011.07.019}{10.1016/j.jspi.2011.07.019}

Ledoit, O., and Wolf, M. (2002). Some Hypothesis Tests 
for the Covariance Matrix When the Dimension Is Large Compared to 
the Sample Size. The Annals of Statistics, 30(4), 1081-1102. 
\href{http://doi.org/10.1214/aos/1031689018}{10.1214/aos/1031689018}

Nagao, H. (1973). On Some Test Criteria for Covariance 
Matrix. The Annals of Statistics, 1(4), 700-709

Srivastava, M. S. (2005). Some Tests Concerning the 
Covariance Matrix in High Dimensional Data. Journal of the Japan 
Statistical Society, 35(2), 251-272. \href{http://doi.org/10.14490/jjss.35.251}{10.14490/jjss.35.251}

Srivastava, M. S., Kollo, T., and Rosen, D. von. (2011). 
Some Tests for the Covariance Matrix with Fewer Observations then 
the Dimension Under Non-normality. Journal of Multivariate Analysis, 
102(6), 1090-1103. \href{http://doi.org/10.1016/j.jmva.2011.03.003}{10.1016/j.jmva.2011.03.003}
}
\seealso{
Other Testing for Structure of Covariance Matrices: \code{\link{structureCovariances}}
}
