% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap_solve_batch.R
\name{lap_solve_batch}
\alias{lap_solve_batch}
\title{Solve multiple assignment problems efficiently}
\usage{
lap_solve_batch(
  x,
  source = NULL,
  target = NULL,
  cost = NULL,
  maximize = FALSE,
  method = "auto",
  n_threads = 1,
  forbidden = NA
)
}
\arguments{
\item{x}{One of: List of cost matrices, 3D array, or grouped data frame}

\item{source}{Column name for source indices (if \code{x} is a grouped data frame)}

\item{target}{Column name for target indices (if \code{x} is a grouped data frame)}

\item{cost}{Column name for costs (if \code{x} is a grouped data frame)}

\item{maximize}{Logical; if TRUE, maximizes total cost (default: FALSE)}

\item{method}{Algorithm to use (default: "auto"). See \code{lap_solve} for options.}

\item{n_threads}{Number of threads for parallel execution (default: 1).
Set to NULL to use all available cores.}

\item{forbidden}{Value to mark forbidden assignments (default: NA)}
}
\value{
A tibble with columns:
\itemize{
\item \code{problem_id}: identifier for each problem
\item \code{source}: source indices for assignments
\item \code{target}: target indices for assignments
\item \code{cost}: cost of each assignment
\item \code{total_cost}: total cost for each problem
\item \code{method_used}: algorithm used for each problem
}
}
\description{
Solve many independent assignment problems at once. Supports lists of matrices,
3D arrays, or grouped data frames. Optional parallel execution via \code{n_threads}.
}
\examples{
# List of matrices
costs <- list(
  matrix(c(1, 2, 3, 4), 2, 2),
  matrix(c(5, 6, 7, 8), 2, 2)
)
lap_solve_batch(costs)

# 3D array
arr <- array(runif(2 * 2 * 10), dim = c(2, 2, 10))
lap_solve_batch(arr)

# Grouped data frame
library(dplyr)
df <- tibble(
  sim = rep(1:5, each = 9),
  source = rep(1:3, times = 15),
  target = rep(1:3, each = 3, times = 5),
  cost = runif(45, 1, 10)
)
df |> group_by(sim) |> lap_solve_batch(source, target, cost)

# Parallel execution (requires n_threads > 1)
lap_solve_batch(costs, n_threads = 2)

}
