% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CortForest.R
\name{CortForest-Class}
\alias{CortForest-Class}
\alias{CortForest}
\title{Bagged Cort estimates}
\usage{
CortForest(
  x,
  p_value_for_dim_red = 0.75,
  n_trees = 10,
  compte_loo_weights = FALSE,
  min_node_size = 1,
  pseudo_data = FALSE,
  number_max_dim = NULL,
  verbose_lvl = 2,
  force_grid = FALSE,
  oob_weighting = TRUE
)
}
\arguments{
\item{x}{The data, must be provided as a matrix with each row as an observation.}

\item{p_value_for_dim_red}{a p_value for the localised dimension reduction test}

\item{n_trees}{Number of trees}

\item{compte_loo_weights}{Defaults to FALSE. Allows to use an automatic re-weighting of the trees in the forest, based on leave-one-out considerations.}

\item{min_node_size}{The minimum number of observation avaliable in a leaf to initialise a split.}

\item{pseudo_data}{set to True if you are already providing data on the copula space.}

\item{number_max_dim}{The maximum number of dimension a split occurs in. Defaults to be all of the dimensions.}

\item{verbose_lvl}{verbosity level : can be 0 (default) or an integer. bigger the integer bigger the output level.}

\item{force_grid}{boolean (default: FALSE). set to TRUE to force breakpoint to be on the n-checkerboard grid in every tree.}

\item{oob_weighting}{boolean (default : TRUE) option to weight the trees with an oob criterion (otherwise they are equally weighted)}
}
\value{
a CortForest object that can be fitted easily to produce a copula estimate.
}
\description{
CortForest class
}
\details{
This class implements the bagging of CORT models, with an oob error minimisation in the weights. See O. Laverny, V. Maume-Deschamps, E. Masiello and D. Rullière (2020) for the details of this density estimation procedure.
}
\examples{
(CortForest(LifeCycleSavings[,1:3],number_max_dim=2,n_trees=2))
}
\references{
\insertRef{laverny2020}{cort}
}
