% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{focus}
\alias{focus}
\alias{focus_}
\title{Focus on section of a correlation data frame.}
\usage{
focus(x, ..., mirror = FALSE)

focus_(x, ..., .dots, mirror)
}
\arguments{
\item{x}{cor_df. See \code{\link{correlate}}.}

\item{...}{One or more unquoted expressions separated by commas. Variable
names can be used as if they were positions in the data frame, so
expressions like `x:y`` can be used to select a range of variables.}

\item{mirror}{Boolean. Whether to mirror the selected columns in the rows or
not.}

\item{.dots}{Use focus_ to do standard evaluations. See \code{\link[dplyr]{select}}.}
}
\value{
A tbl or, if mirror = TRUE, a \code{cor_df} (see \code{\link{correlate}}).
}
\description{
Convenience function to select a set of variables from a correlation matrix
to keep as the columns, and exclude these or all other variables from the rows. This
function will take a \code{\link{correlate}} correlation matrix, and
expression(s) suited for dplyr::select(). The selected variables will remain
in the columns, and these, or all other variables, will be excluded from the
rows based on `\code{same}. For a complete list of methods for using this
function, see \code{\link[dplyr]{select}}.
}
\examples{
library(dplyr)
x <- correlate(mtcars)
focus(x, mpg, cyl) # Focus on correlations of mpg and cyl with all other variables
focus(x, -disp, -mpg, mirror = TRUE) # Remove disp and mpg from columns and rows

x <- correlate(iris[-5])
focus(x, -matches("Sepal")) # Focus on correlations of non-Sepal
# variables with Sepal variables.
}
