% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_corrgraph.R
\name{plot.corrgrapher}
\alias{plot.corrgrapher}
\title{Visualize correlations in a corrgrapher object}
\usage{
\method{plot}{corrgrapher}(x, ...)
}
\arguments{
\item{x}{a \code{corrgrapher} object. See \code{\link{corrgrapher}}.}

\item{...}{other parameters, passed directly to \code{\link{visNetwork}} function (such as \code{main}, \code{submain}, \code{width}, \code{height} etc.)}
}
\value{
A \code{\link{visNetwork}} object; graph. On this graph, the edges are treated as springs. 
  The variables correlated \strong{strongly} (positively or negatively) are \strong{close} to each other, 
  and those not (or weakly) correlated - \strong{far} from each other.
}
\description{
Visualize correlations between variables, using previously created \code{corrgrapher} object.
}
\examples{
df <- as.data.frame(datasets::Seatbelts)[,1:7] # drop the binary target variable
cgr <- corrgrapher(df)
plot(cgr)
}
\seealso{
\code{\link{corrgrapher}}
}
