% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ciplot.corregp}
\alias{ciplot}
\alias{ciplot.corregp}
\title{Plotting Confidence Intervals for Correspondence Regression}
\usage{
\method{ciplot}{corregp}(x, parm = "x", axis, cl = 0.95, nq = TRUE,
  horiz = FALSE, na.rm = FALSE, type = "p", col = "darkgrey",
  cex = par("cex"), font = par("font"), alim = NULL, adir = 1,
  ecol = "darkgrey", ewid = par("lwd"), etyp = par("lty"), psym = 16,
  pcol = par("col"), pcex = cex, pbgc = par("bg"), lwd = ewid,
  lty = etyp, sfrac = 0.01, gap = 1, main = NULL, sub = NULL, ...)

ciplot(x, ...)
}
\arguments{
\item{x}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{parm}{The parameter for which to plot the confidence intervals. Can be either \code{"y"}, \code{"x"}, or any vector of term names in X, level names in X or
level names in Y. Defaults to \code{"x"}.}

\item{axis}{The axis for which to plot the confidence intervals.}

\item{cl}{The confidence level for the confidence intervals. Defaults to \code{0.95}.}

\item{nq}{Logical specifying whether to use a normal quantile (i.e. apply \code{\link[stats]{qnorm}}) in the computation of the confidence intervals.
Defaults to \code{TRUE}. If \code{FALSE}, then the confidence intervals are computed directly with the \code{\link[stats]{quantile}} function.}

\item{horiz}{Logical specifying whether the confidence intervals should be plotted horizontally or not. Defaults to \code{FALSE}.}

\item{na.rm}{Logical specifying whether to omit \code{NA} coordinates from the plot. Defaults to \code{FALSE}.}

\item{type}{The type of plot: see \code{\link[graphics]{plot.default}}. For correspondence regression, there is an additional option \code{"labs"} which
plots the text labels at the centers of the confidence intervals. Defaults to \code{"p"}.}

\item{col}{Color of the text labels: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{cex}{Character expansion factor: a number to specify the size of the text labels.}

\item{font}{Font of the text labels: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic. Defaults to \code{1}.}

\item{alim}{Vector of two values specifying the lower and upper limit between which to plot the axis.}

\item{adir}{Reading direction of the text labels on the (horizontal) axis: either a \code{numeric} value between \code{0} and \code{3} (see the \code{las} argument in
the graphical parameters \code{\link[graphics]{par}}) or a \code{character} value matching either \code{"horizontal"} or \code{"vertical"}. Defaults to \code{1} (horizontal).}

\item{ecol}{Color of the error bars: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{ewid}{Width of the error bars: a number to specify the line width.}

\item{etyp}{Line type of the error bars: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"}, \code{3} or \code{"dotted"},
\code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}. Defaults to \code{1}.}

\item{psym}{The symbol (or "plotting character") to use for the centers of the confidence intervals.}

\item{pcol}{Color of the center symbol: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{pcex}{Character expansion factor of the center symbol.}

\item{pbgc}{Background color of the center symbol: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{lwd}{Width of all lines except for the error bars, e.g. the connecting lines: a number to specify the line width.}

\item{lty}{Line type of all lines except for the error bars, e.g. the connecting lines: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"},
\code{3} or \code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}. Defaults to \code{1}.}

\item{sfrac}{Width of "crossbar" at the end of error bar as a fraction of the x plotting region. Defaults to 0.01.}

\item{gap}{Space left between the center of the error bar and the lines marking the error bar in units of the height (width) of the letter "O". Defaults to 1.0.}

\item{main}{The main title of the plot.}

\item{sub}{The subtitle of the plot.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A plot window containing the confidence intervals.
}
\description{
Method to plot confidence intervals for coordinates in correspondence regression.
}
\details{
\code{ciplot} (of a \code{corregp} output) makes use of \code{\link[gplots]{plotCI}} from the package \pkg{gplots}.
}
\examples{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
ciplot(haireye.crg, parm = "y", axis = 1)
ciplot(haireye.crg, parm = c("Hair", "Sex"), axis = 1)
}
\seealso{
\code{\link{ci}}, \code{\link[gplots]{plotCI}}.
}

