% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_contexts.r
\name{tCorpus$subset_query}
\alias{tCorpus$subset_query}
\title{Subset tCorpus token data using a query}
\arguments{
\item{query}{A character string that is a query. See \link{search_contexts} for query syntax.}

\item{feature}{The name of the feature columns on which the query is used.}

\item{context_level}{Select whether the query and subset are performed at the document or sentence level.}

\item{window}{If used, uses a word distance as the context (overrides context_level)}

\item{copy}{If true, return modified copy of data instead of subsetting the input tcorpus by reference.}
}
\description{
A convenience function that searches for contexts (documents, sentences), and uses the results to \link[=subset]{subset} the tCorpus token data.

See the documentation for \link[=search_contexts]{search_contexts} for an explanation of the query language.

\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{subset_query(query, feature = 'token', context_level = c('document','sentence','window'))}
}
\examples{
text = c('A B C', 'D E F. G H I', 'A D', 'GGG')
tc = create_tcorpus(text, doc_id = c('a','b','c','d'), split_sentences = TRUE)

## subset by reference
tc$subset_query('A')
tc$meta

## using copy mechanic
class(tc$tokens$doc_id)
tc2 = tc$subset_query('A AND D', copy=TRUE)

tc2$get_meta()

tc$meta ## (unchanged)
}
