% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_tcorpus.r
\name{docfreq_filter}
\alias{docfreq_filter}
\title{Support function for subset method}
\usage{
docfreq_filter(x, min = -Inf, max = Inf, top = NULL, bottom = NULL,
  doc_id = parent.frame()$doc_id)
}
\arguments{
\item{x}{the name of the feature column. Can be given as a call or a string.}

\item{min}{A number, setting the minimum document frequency value}

\item{max}{A number, setting the maximum document frequency value}

\item{top}{A number. If given, only the top x features with the highest document frequency are TRUE}

\item{bottom}{A number. If given, only the bottom x features with the highest document frequency are TRUE}

\item{doc_id}{Added for reference, but should not be used. Automatically takes doc_id from tCorpus if the docfreq_filter function is used within the subset method.}
}
\description{
Support function to enable subsetting by document frequency stats of a given feature.
Should only be used within the tCorpus subset method, or any tCorpus method that supports a subset argument.
}
\examples{
tc = create_tcorpus(c('a a a b b', 'a a c c'))

tc$tokens
tc$subset(subset = docfreq_filter(token, min=2))
tc$tokens
}
