/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.eval;

import java.util.Collection;
import java.util.Set;
import org.corehunter.data.GenotypeData;
import org.corehunter.objectives.eval.AllelicDiversityEvaluation;

public class HeterozygousLociEvaluation
extends AllelicDiversityEvaluation {
    public HeterozygousLociEvaluation(Collection<Integer> ids, GenotypeData data) {
        super(ids, data);
    }

    public HeterozygousLociEvaluation(AllelicDiversityEvaluation curEval, Set<Integer> add, Set<Integer> remove, GenotypeData data) {
        super(curEval, add, remove, data);
    }

    @Override
    public double getValue() {
        if (this.getNumSelected() == 0) {
            return 0.0;
        }
        double[][] avgGeno = this.getAverageGenotype();
        double total = 0.0;
        int numberOfMarkers = avgGeno.length;
        for (int m = 0; m < numberOfMarkers; ++m) {
            int numberOfAlleles = avgGeno[m].length;
            double summedAverageAlleleFrequencySquared = 0.0;
            for (int a = 0; a < numberOfAlleles; ++a) {
                summedAverageAlleleFrequencySquared += avgGeno[m][a] * avgGeno[m][a];
            }
            total += 1.0 - summedAverageAlleleFrequencySquared;
        }
        return total / (double)numberOfMarkers;
    }
}

