% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convoSPAT_summplot.R
\name{plot_preds}
\alias{plot_preds}
\title{Plot kriging predictions and standard errors.}
\usage{
plot_preds(locations, predmeans, predSDs, main1 = "Predictions",
  main2 = "Prediction standard errors", grid.locations = TRUE)
}
\arguments{
\item{locations}{A N x 2 matrix of prediction locations.}

\item{predmeans}{Vector; predicted mean values corresponding to the
prediction locations.}

\item{predSDs}{Vector; predicted standard errors corresponding to the
prediction locations.}

\item{main1,main2}{String; specifies plot titles for panels 1 and 2.}

\item{grid.locations}{Logical; indicates if the prediction locations
are on a rectangular grid (\code{TRUE}) or not (\code{FALSE}).}
}
\value{
A plot with two panels is printed, showing the predictions and
standard errors.
}
\description{
This function uses \code{\link[fields]{image.plot}} and
\code{\link[fields]{quilt.plot}} to quickly plot predictions. If the
predicted values are on a rectangular grid, \code{image.plot} is
used to improve the appearance.
}
\examples{
\dontrun{
plot_preds( locations = pred.locations, predmeans = pred.NS$pred.means,
predSDs = pred.NS$pred.SDs, grid.locations = TRUE )
}
}

