% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyamato.R
\name{svyamato}
\alias{svyamato}
\alias{svyamato.survey.design}
\alias{svyamato.svyrep.design}
\alias{svyamato.DBIsvydesign}
\title{Amato index (EXPERIMENTAL)}
\usage{
svyamato(formula, design, ...)

\method{svyamato}{survey.design}(formula, design, standardized = FALSE, na.rm = FALSE, ...)

\method{svyamato}{svyrep.design}(formula, design, standardized = FALSE, na.rm = FALSE, ...)

\method{svyamato}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable.}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{standardized}{If \code{standardized = TRUE}, returns the standardized Amato index, i.e., a linear tranformation of the amato index.}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Amato index, a measure of inequality.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.

The Amato index is the length of the Lorenz curve.
}
\note{
This function is experimental and is subject to change in later versions.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)


# variable without missing values
svyamato(~eqincome, des_eusilc)
svyamato(~eqincome, des_eusilc_rep)

# subsetting:
svyamato(~eqincome, subset( des_eusilc, db040 == "Styria"))
svyamato(~eqincome, subset( des_eusilc_rep, db040 == "Styria"))

\dontrun{

# variable with with missings
svyamato(~py010n, des_eusilc )
svyamato(~py010n, des_eusilc_rep )

svyamato(~py010n, des_eusilc, na.rm = TRUE )
svyamato(~py010n, des_eusilc_rep, na.rm = TRUE )

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )


# variable without missing values
svyamato(~eqincome, dbd_eusilc)

# subsetting:
svyamato(~eqincome, subset( dbd_eusilc, db040 == "Styria"))

# variable with with missings
svyamato(~py010n, dbd_eusilc )

svyamato(~py010n, dbd_eusilc, na.rm = TRUE )


dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Lucio Barabesi, Giancarlo Diana and Pier Francesco Perri (2016). Linearization of inequality indexes in the design-based framework.
Statistics. URL \url{http://www.tandfonline.com/doi/pdf/10.1080/02331888.2015.1135924}.

Barry C. Arnold (2012). On the Amato inequality index.
Statistics & Probability Letters, v. 82, n. 8, August 2012, pp. 1504-1506, ISSN 0167-7152.
URL \url{http://dx.doi.org/10.1016/j.spl.2012.04.020}.
}
\seealso{
\code{\link{svygini}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
