% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts_helmert.R
\name{helmert_code}
\alias{helmert_code}
\title{Helmert code}
\usage{
helmert_code(n)
}
\arguments{
\item{n}{Integer umber of factor levels to compute contrasts for.}
}
\value{
A contrast matrix with dimensions n rows and (n-1) columns.
}
\description{
R's \code{\link[stats:contrast]{stats::contr.helmert()}} function is unscaled, meaning
that you need to scale the coefficients of a model fit to get the actual
comparisons of interest. This version will automatically scale the contrast
matrix such that the coefficients are the expected scaled values.
}
\details{
Helmert coding compares each level to the total mean of all levels
that have come before it. Differs from backward difference coding, which
compares only pairs of levels (not a level to a cumulative mean of levels)

Example interpretation for a 4 level factor:
\itemize{
\item Intercept = Grand mean (mean of the means of each level)
\item grp2 = mean(grp2) - mean(grp1)
\item grp3 = mean(grp3) - mean(grp1, grp2)
\item grp4 = mean(grp4) - mean(grp1, grp2, grp3)
}
}
\examples{

mydf <- data.frame(
  grp = gl(4,5),
  resp = c(seq(1, 5), seq(5, 9), seq(10, 14), seq(15, 19))
)

mydf <- set_contrasts(mydf, grp ~ helmert_code)
lm(resp ~ grp, data = mydf)
}
