set.seed(3755232)

context("Output class, name and length")

# Common elements ======================================== #

n <- lampasona_2013
n2 <- peterson_2007
n3 <- lydersen_2012a
n4 <- doll_hill_1950
n5 <- matrix(1:9, 3)
n6 <- matrix(1:8, ncol = 2)
n7 <- floor(lydersen_2012a / 4)

# Unit tests ============================================= #
set.seed(6492798) # useful for functions using Bootstrap
t001 <- Adjusted_inv_sinh_CI_OR_2x2(n)
t002 <- Adjusted_inv_sinh_CI_ratio_2x2(n)
t003 <- Adjusted_log_CI_2x2(n)
t004 <- AgrestiCaffo_CI_2x2(n)
t005 <- AgrestiCoull_CI_1x2(33, 45)
t006 <- BaptistaPike_exact_conditional_CI_2x2(n)
t007 <- BaptistaPike_midP_CI_2x2(n)
t008 <- Bhapkar_test_paired_cxc(n2)
t009 <- Blaker_exact_CI_1x2(13, 16)
t010 <- Blaker_exact_test_1x2(13, 16, .5)
t011 <- Blaker_midP_CI_1x2(13, 16)
t012 <- Arcsine_CI_1x2(13, 16)
t013 <- Blaker_midP_test_1x2(13, 16, .5)
t014 <- BonettPrice_hybrid_Wilson_score_CI_CC_paired_2x2(n)
t015 <- BonettPrice_hybrid_Wilson_score_CI_paired_2x2(n)
t016 <- Bonferroni_type_CIs_paired_cxc(n)
t017 <- Bonferroni_type_CIs_rxc(n)
t018 <- Brant_test_2xc(n3)
t019 <- BreslowDay_homogeneity_test_stratified_2x2(n4)
t020 <- Chacko_test_1xc(n)
t021 <- ClopperPearson_exact_CI_1x2_beta_version(13, 16)
t022 <- ClopperPearson_exact_CI_1x2(13, 16)
t023 <- ClopperPearson_midP_CI_1x2(13, 16)
t024 <- Cochran_Q_test_stratified_2x2(n4)
t025 <- CochranArmitage_CI_rx2(n, 1:2)
t026 <- CochranArmitage_exact_cond_midP_tests_rx2(n2, 1:4)
t027 <- CochranArmitage_MH_tests_rx2(n2, 1:4)
t028 <- CochranMantelHaenszel_test_stratified_2x2(n4)
t029 <- Cornfield_exact_conditional_CI_2x2(n)
t030 <- Cornfield_midP_CI_2x2(n)
t031 <- Cumulative_models_for_2xc(n3)
t032 <- Cumulative_models_for_rxc(n3)
t033 <- Exact_binomial_test_1x2(13, 16, .5)
t034 <- Exact_cond_midP_linear_rank_tests_2xc(n5)
t035 <- Exact_cond_midP_tests_rxc(n5[, 1:2])
t036 <- Exact_cond_midP_unspecific_ordering_rx2(n6, "decreasing")
t037 <- Exact_multinomial_test_1xc(1:3, seq(.4, .6, .1))
t038 <- Exact_unconditional_test_2x2(n)
t039 <- Fisher_exact_test_2x2(n)
t040 <- t038
t041 <- Fisher_midP_test_2x2(n)
t042 <- FisherFreemanHalton_asymptotic_test_rxc(n)
t043 <- FleissEveritt_test_paired_cxc(n5)
t044 <- FleissLevinPaik_test_paired_cxc(n5)
t045 <- gamma_coefficient_rxc_bca(n, nboot = 160)
t046 <- gamma_coefficient_rxc(n)
t047 <- Gart_adjusted_logit_CI_2x2(n)
t048 <- Gold_Wald_CIs_1xc(n)
t049 <- Goodman_Wald_CIs_1xc(n)
t050 <- Goodman_Wald_CIs_for_diffs_1xc(n)
t051 <- Goodman_Wilson_score_CIs_1xc(n)
t052 <- Independence_smoothed_logit_CI_2x2(n)
t053 <- Inv_sinh_CI_OR_2x2(n)
t054 <- Inv_sinh_CI_ratio_2x2(n)
t055 <- InverseVariance_estimate_stratified_2x2(n4)
t056 <- Jeffreys_CI_1x2(13, 16)
t057 <- JonckheereTerpstra_test_rxc(n)
t058 <- Katz_log_CI_2x2(n)
t059 <- Kendalls_tau_b_rxc_bca(n, nboot = 160)
t060 <- Kendalls_tau_b_rxc(n)
t061 <- Koopman_asymptotic_score_CI_2x2(n)
t062 <- KruskalWallis_asymptotic_test_rxc(n)
t063 <- linear_by_linear_test_rxc(n)
t064 <- LR_CI_1x2(13, 16)
t065 <- LR_test_1x2(13, 16, .3)
t066 <- LR_test_1xc(1:3, c(.3, .5, .1))
t067 <- LR_test_2x2(n)
t068 <- MantelHaenszel_estimate_stratified_2x2(n4)
t069 <- MantelHaenszel_test_2xc(n)
t070 <- McNemar_asymptotic_test_CC_paired_2x2(n)
t071 <- McNemar_asymptotic_test_paired_2x2(n)
t072 <- McNemar_exact_cond_test_paired_2x2(n2)
t073 <- McNemar_exact_unconditional_test_paired_2x2(n)
t074 <- McNemar_midP_test_paired_2x2(n)
t075 <- McNemarBowker_test_paired_cxc(n)
t076 <- Mee_asymptotic_score_CI_2x2(n)
t077 <- MidP_binomial_test_1x2(13, 16, .3)
t078 <- MidP_multinomial_test_1xc(n, runif(4))
t079 <- MiettinenNurminen_asymptotic_score_CI_difference_2x2(n)
t080 <- MiettinenNurminen_asymptotic_score_CI_OR_2x2(n)
t081 <- MiettinenNurminen_asymptotic_score_CI_ratio_2x2(n)
t082 <- ML_estimates_and_CIs_stratified_2x2(n4)
t083 <- MOVER_R_Wilson_CI_OR_2x2(n)
t084 <- MOVER_R_Wilson_CI_ratio_2x2(n)
t085 <- MOVER_Wilson_score_CI_paired_2x2(n)
t086 <- Newcombe_hybrid_score_CI_2x2(n)
t087 <- Newcombe_square_and_add_CI_paired_2x2(n)
t088 <- Pearson_chi_squared_test_1xc(n, runif(4))
t089 <- Pearson_chi_squared_test_2x2(n)
t090 <- Pearson_chi_squared_test_CC_2x2(n)
t091 <- Pearson_correlation_coefficient_rxc_bca(n, nboot = 160)
t092 <- Pearson_correlation_coefficient_rxc(n)
t093 <- Pearson_LR_homogeneity_test_stratified_2x2(n4)
t094 <- Pearson_LR_test_common_effect_stratified_2x2(n4)
t095 <- Pearson_LR_tests_cum_OR_2xc(n)
t096 <- Pearson_LR_tests_rxc(n)
t097 <- Pearson_LR_tests_unspecific_ordering_rx2(n, "increasing")
t098 <- Pearson_residuals_rxc(n)
t099 <- Peto_homogeneity_test_stratified_2x2(n4)
t100 <- Peto_OR_estimate_stratified_2x2(n4)
t101 <- PriceBonett_approximate_Bayes_CI_2x2(n)
t102 <- QuesenberryHurst_Wilson_score_CIs_1xc(n)
t103 <- RBG_test_and_CI_stratified_2x2(n4)
t104 <- Scheffe_type_CIs_paired_cxc(n)
t105 <- Scheffe_type_CIs_rxc(n)
t106 <- Score_test_1x2(13, 16, .5)
t107 <- Score_test_and_CI_marginal_mean_scores_paired_cxc(n, runif(4))
t108 <- Score_test_CC_1x2(13, 16, .5)
t109 <- Score_test_for_effect_in_the_probit_model_2xc(n, rnorm(4))
t110 <- Spearman_correlation_coefficient_rxc_bca(n, nboot = 160)
t111 <- Spearman_correlation_coefficient_rxc(n)
t112 <- invisible(capture.output(stratified_2x2_tables(n4)))
t113 <- Stuart_test_paired_cxc(n2)
t114 <- Tang_asymptotic_score_CI_paired_2x2(n)
t115 <- Tango_asymptotic_score_CI_paired_2x2(n)
t116 <- invisible(capture.output(the_1x2_table_CIs(13, 16)))
t117 <- invisible(capture.output(the_1x2_table_tests(13, 16, .4)))
t118 <- invisible(capture.output(the_1xc_table_CIs(n)))
t119 <- invisible(capture.output(the_1xc_table_tests(n, runif(4))))
t120 <- invisible(capture.output(the_2x2_table_CIs_difference(n)))
t121 <- invisible(capture.output(the_2x2_table_CIs_OR(n)))
t122 <- invisible(capture.output(the_2x2_table_CIs_ratio(n)))
t123 <- invisible(capture.output(the_2x2_table_tests(n)))
t124 <- invisible(capture.output(the_2xc_table(n7, direction = "decreasing")))
t125 <- invisible(capture.output(the_paired_2x2_table_CIs_difference(n)))
t126 <- invisible(capture.output(the_paired_2x2_table_CIs_OR(n)))
t127 <- invisible(capture.output(the_paired_2x2_table_CIs_ratio(n)))
t128 <- invisible(capture.output(the_paired_2x2_table_tests(n)))
t129 <- invisible(capture.output(the_paired_cxc_table_nominal(n)))
t130 <- invisible(capture.output(the_paired_cxc_table_ordinal(n, rnorm(4))))
t131 <- invisible(capture.output(the_rx2_table(n2, skip_exact = TRUE)))
t132 <- invisible(capture.output(the_rxc_table(n2, nboot = 0)))
t133 <- Transformed_Blaker_exact_CI_paired_2x2(n)
t134 <- Transformed_Clopper_Pearson_exact_CI_paired_2x2(n)
t135 <- Transformed_Clopper_Pearson_midP_CI_paired_2x2(n)
t136 <- Transformed_Wilson_score_CI_paired_2x2(n)
t137 <- Trend_estimate_CI_tests_rx2(n, 1:2)
t138 <- Uncorrected_asymptotic_score_CI_2x2(n)
t139 <- Wald_CI_1x2(13, 16)
t140 <- Wald_CI_2x2(n)
t141 <- Wald_CI_AgrestiMin_paired_2x2(n)
t142 <- Wald_CI_BonettPrice_paired_2x2(n)
t143 <- Wald_CI_CC_1x2(13, 16)
t144 <- Wald_CI_CC_2x2(n)
t145 <- Wald_CI_diff_CC_paired_2x2(n)
t146 <- Wald_CI_diff_paired_2x2(n)
t147 <- Wald_CI_OR_Laplace_paired_2x2(n)
t148 <- Wald_CI_OR_paired_2x2(n)
t149 <- Wald_CI_ratio_paired_2x2(n)
t150 <- Wald_test_1x2(13, 16, .1)
t151 <- Wald_test_and_CI_common_diff_stratified_2x2(n4)
t152 <- Wald_test_and_CI_common_ratio_stratified_2x2(n4)
t153 <- Wald_test_and_CI_marginal_mean_ranks_paired_cxc(n)
t154 <- Wald_test_and_CI_marginal_mean_scores_paired_cxc(n, rnorm(4))
t155 <- Wald_test_CC_1x2(13, 16, .1)
t156 <- Wilson_score_CI_1x2(13, 16)
t157 <- Wilson_score_CI_CC_1x2(13, 16)
t158 <- Woolf_logit_CI_2x2(n)
t159 <- Woolf_test_and_CI_stratified_2x2(n4)
t160 <- Z_unpooled_test_2x2(n)

function_output_objects <- ls(pattern = "t\\d{3}")

test_that("Output class and names are the expected", {
  # Regular tests
  for (t in function_output_objects[c(1:111, 113:115, 133:160)]) {
    expect_is(get(t), "contingencytables_result")
    expect_named(attributes(get(t)), c("names", "class", "print_structure"))
  }

  # Aggregated tests (tables)
  for (t in function_output_objects[c(112, 116:132)]) {
    expect_is(get(t), "character")
    expect_named(attributes(get(t)), NULL)
  }
})
