% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_2x2_tables.R
\name{stratified_2x2_tables}
\alias{stratified_2x2_tables}
\title{Stratified 2x2 tables}
\usage{
stratified_2x2_tables(n, alpha = 0.05)
}
\arguments{
\item{n}{the observed table (a 2x2xk matrix, where k is the number of strata)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
NULL. This function should be called for its printed output
}
\description{
Stratified 2x2 tables
}
\examples{
# Smoking and lung cancer (Doll and Hill, 1950)
stratified_2x2_tables(doll_hill_1950)

# Prophylactice use of Lidocaine in myocardial infarction (Hine et al., 1989)
stratified_2x2_tables(hine_1989)

}
