% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_1xc_table_tests.R
\name{the_1xc_table_tests}
\alias{the_1xc_table_tests}
\title{The 1xc table tests}
\usage{
the_1xc_table_tests(n, pi0, chacko.test = FALSE)
}
\arguments{
\item{n}{the observed counts (a 1xc vector, where c is the number of categories)}

\item{pi0}{given probabilities (a 1xc vector)}

\item{chacko.test}{if TRUE, only performs the Chacko test}
}
\value{
NULL. This function should be called for its printed output
}
\description{
The 1xc table tests
}
\examples{
# Genotype counts for SNP rs 6498169 in RA patients
the_1xc_table_tests(n = c(276, 380, 118), pi0 = c(0.402, 0.479, 0.119))
# subset of 10 patients
the_1xc_table_tests(n = c(6, 1, 3), pi0 = c(0.402, 0.479, 0.119))
# Example for the Chacko test: Hypothetical experiment
the_1xc_table_tests(n = c(1, 4, 3, 11, 9), pi0 = c(0.402, 0.479, 0.119), TRUE)
}
