% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gold_Wald_CIs_1xc.R
\name{Gold_Wald_CIs_1xc}
\alias{Gold_Wald_CIs_1xc}
\title{The Gold Wald simultaneous intervals for the multinomial probabilities}
\usage{
Gold_Wald_CIs_1xc(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 1xc vector, where c is the number of categories)}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
A data frame containing lower, upper and point estimates of the statistic
}
\description{
The Gold Wald simultaneous intervals for the multinomial probabilities (with Scheffe adjustment)

Described in Chapter 3 "The 1xc Table and the Multinomial Distribution"
}
\examples{
# Genotype counts for SNP rs 6498169 in RA patients
Gold_Wald_CIs_1xc(n = c(276, 380, 118))
}
