% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-IteratorS3.R
\name{iterS3}
\alias{iterS3}
\alias{iter}
\alias{iter.Container}
\alias{iter.default}
\alias{is.iterator}
\alias{is.iterable}
\alias{begin}
\alias{get_value}
\alias{get_next}
\alias{has_next}
\alias{has_value}
\alias{pos}
\alias{next_iter}
\alias{reset_iter}
\alias{length.Iterator}
\title{Iterate over Sequences}
\usage{
iter(x, ...)

\method{iter}{Container}(x, ...)

\method{iter}{default}(x, ...)

is.iterator(x)

is.iterable(x)

begin(it)

get_value(it)

get_next(it)

has_next(it)

has_value(it)

pos(it)

next_iter(it)

reset_iter(it)

\method{length}{Iterator}(x)
}
\arguments{
\item{x}{an object of class \link{Iterable} or any other \code{R} object. In the
latter case, \code{x} will always be coerced to a base \code{R} \link{list} prior to creating
the \link{Iterator}.}

\item{...}{other parameters passed to or from methods}

\item{it}{\code{Iterator} object}
}
\value{
\code{length} returns the number of elements that can be iterated over.
}
\description{
An \code{Iterator} is an object that allows to iterate over
sequences. It implements \code{\link[=next_iter]{next_iter()}} and \code{\link[=get_value]{get_value()}} to iterate and retrieve the
value of the sequence it is associated with.
For documentation of the methods see \link{Iterator}.
}
\examples{
# Numeric Vector
v = 1:3
it = iter(v)
it

try(it$get_value())  # iterator does not point at a value

has_value(it)
has_next(it)
next_iter(it)
get_value(it)
get_next(it)
get_next(it)
it
has_next(it)
begin(it)
get_value(it)
reset_iter(it)

# Works on copy of Container
co = container(1, 2, 3)
it = iter(co)
get_next(it)
ref_discard(co, 2)
co
it
get_next(it)
ref_clear(co)
co
it
get_next(it)
begin(it)
}
\seealso{
For the class documentation see \link{Iterator}.
}
