% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFunctions_1_0_2.r
\name{makehistory.two}
\alias{makehistory.two}
\title{Function to create joint exposure history for two distinct time-varying exposures}
\usage{
makehistory.two(input, id, group = NULL, exposure.a, exposure.b,
  name.history.a = "ha", name.history.b = "hb", times)
}
\arguments{
\item{input}{dataframe in wide format (e.g., indexed by person)}

\item{id}{unique observation identifier e.g. "id"}

\item{group}{an optional baseline variable upon which to aggregate the exposure history. This argument provides a way to adjust the metrics for a baseline covariate. For example, in the context of a trial, the grouping variable coul be treatment assignment. In the context of a cohort study, this could be site e.g. "v".}

\item{exposure.a}{the root name for the first exposure e.g. "a"}

\item{exposure.b}{the root name for the second exposure e.g. "z"}

\item{name.history.a}{desired root name for the first time-indexed history variables e.g. "ha"}

\item{name.history.b}{desired root name for the second time-indexed history variables e.g. "hb"}

\item{times}{a vector of measurement times e.g. c(0,1,2)}
}
\value{
A "wide" dataframe with an added set of
exposure history variables for each of the two time-varying
exposures, properly accounting for their temporal ordering
(i.e. exposure "a" precedes exposure "b" at any time t).
The new history variables will use the time-indices in the
exposure vectors you supply.
}
\description{
Function to create joint exposure history for two distinct time-varying exposures
}
\details{
When the exposure is multivariate, the idea is to diagnose each exposure separately (see eAppendix of Jackson 2016). From the perspective of using the R-functions, the only difference is to use exposure history based on all exposures that comprise the multivariate exposure. It is important that such joint exposure history accurately reflect the ordering of each component exposure. The function makehistory.two() creates an appropriate joint exposure history for each of two exposures, assuming that exposures in its argument list.exposure.a (e.g. A) precede those in list.exposure.b (e.g. Z) at any given index as described in the eAppendix of Jackson 2016. In that example, exposure A(t) always precedes exposure Z(t) such that the joint history of A(2) is A(1),A(0),Z(0) while the joint history of Z(2) is A(1),A(0),Z(1),Z(0). If one exposure does not precede the other, investigators will still need to use an appropriate joint exposure history and can specify either order as desired. Note that the exposure history produced by the function makehistory.two()will be inappropriate if the relative ordering of A(t) and Z(t) varies over time.
}
\examples{
# Simulate wide data set for two subjects
id <- as.numeric(c(1, 2))
a_0 <- as.numeric(c(0, 1))
a_1 <- as.numeric(c(1, 1))
a_2 <- as.numeric(c(1, 0))
z_0 <- as.numeric(c(1, 0))
z_1 <- as.numeric(c(0, 0))
z_2 <- as.numeric(c(0, 1))
l_0 <- as.numeric(rbinom(2, 1, 0.5))
l_1 <- as.numeric(rbinom(2, 1, 0.5))
l_2 <- as.numeric(rbinom(2, 1, 0.5))
m_0 <- as.numeric(rbinom(2, 1, 0.5))
m_1 <- as.numeric(rbinom(2, 1, 0.5))
m_2 <- as.numeric(rbinom(2, 1, 0.5))
n_0 <- as.numeric(rbinom(2, 1, 0.5))
n_1 <- as.numeric(rbinom(2, 1, 0.5))
n_2 <- as.numeric(rbinom(2, 1, 0.5))

mydata.wide <- data.frame(id, a_0, a_1, a_2,
                          z_0, z_1, z_2,
                          l_0, l_1, l_2,
                          m_0, m_1, m_2,
                          n_0, n_1, n_2)

# Run the makehistory.two() function
mydata.history <- makehistory.two(input=mydata.wide,
                                  id="id",
                                  times=c(0,1,2),
                                  exposure.a="a",
                                  exposure.b="z",
                                  name.history.a="ha",
                                  name.history.b="hb"
                                 )
}
