% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFunctions_1_0_2.r
\name{makehistory.one}
\alias{makehistory.one}
\title{Function to create exposure history for a single time varying exposure.}
\usage{
makehistory.one(input, id, times, group = NULL, exposure,
  name.history = "h")
}
\arguments{
\item{input}{dataframe in wide format (e.g., indexed by person)}

\item{id}{unique observation identifier e.g. "id"}

\item{times}{a vector of measurement times e.g. c(0,1,2)}

\item{group}{an optional baseline variable upon which to aggregate the exposure history. This argument provides a way to adjust the metrics for a baseline covariate. For example, in the context of a trial, the grouping variable could be treatment assignment. In the context of a cohort study, this could be site e.g. "v".}

\item{exposure}{the root name for exposure e.g. "a"}

\item{name.history}{desired root name for time-indexed history variables e.g. "h"}
}
\value{
A "wide" dataframe with an added set of exposure
history variables for a time-varying exposure. The new
history variables will use the time-indices in the exposure
vectors you supply.
}
\description{
Function to create exposure history for a single time varying exposure.
}
\examples{
# Simulate wide data set for two subjects
id <- as.numeric(c(1, 2))
a_0 <- as.numeric(c(0, 1))
a_1 <- as.numeric(c(1, 1))
a_2 <- as.numeric(c(1, 0))
l_0 <- as.numeric(rbinom(2, 1, 0.5))
l_1 <- as.numeric(rbinom(2, 1, 0.5))
l_2 <- as.numeric(rbinom(2, 1, 0.5))
m_0 <- as.numeric(rbinom(2, 1, 0.5))
m_1 <- as.numeric(rbinom(2, 1, 0.5))
m_2 <- as.numeric(rbinom(2, 1, 0.5))
n_0 <- as.numeric(rbinom(2, 1, 0.5))
n_1 <- as.numeric(rbinom(2, 1, 0.5))
n_2 <- as.numeric(rbinom(2, 1, 0.5))

mydata.wide <- data.frame(id, a_0, a_1, a_2,
                          l_0, l_1, l_2,
                          m_0, m_1, m_2,
                          n_0, n_1, n_2)

# Run the makehistory.one() function
mydata.history <- makehistory.one(input=mydata.wide,
                                 id="id",
                                  times=c(0,1,2),
                                  exposure="a",
                                  name.history="h"
                                  )
}
