% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\encoding{UTF-8}
\name{disorders}
\alias{disorders}
\title{Meta-analytic correlations among Big Five personality traits and psychological disorders}
\format{
list with entries \code{r} (mean observed correlations), \code{rho} (mean
corrected correlations), \code{n} (sample sizes), \code{sevar_r} (sampling error
variances for mean observed correlations), \code{sevar_rho} (sampling error
variances for mean corrected correlations), and \code{source} (character labels
indicating which meta-analytic correlations came from the same source)
}
\usage{
data(disorders)
}
\description{
Big Five intercorrelations from Davies et al. (2015). Big Five–psychological
disorder correlations from Kotov et al. (2010). Note that there were several
duplicate or missing values in the reported data table in the published
article. These results are based on corrected data values.
}
\examples{
data(disorders)
}
\references{
Davies, S. E., Connelly, B. L., Ones, D. S., & Birkland, A. S. (2015).
The general factor of personality: The “Big One,” a self-evaluative trait, or a methodological gnat that won’t go away?
\emph{Personality and Individual Differences, 81}, 13–22. \doi{10.1016/j.paid.2015.01.006}

Kotov, R., Gamez, W., Schmidt, F., & Watson, D. (2010). Linking “big” personality traits to anxiety, depressive, and substance use disorders: A meta-analysis.
\emph{Psychological Bulletin, 136}(5), 768–821. \doi{10.1037/a0020327}
}
\keyword{datasets}
